/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.observers;

import com.sun.javafx.binding.ExpressionHelper;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Binding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class BindingSubscriber<T, S>
implements Subscriber<T>,
ObservableValue<S>,
Binding<S> {
    private final Function<T, S> unmaskingFunction;
    private final Consumer<Throwable> onError;
    private final ConnectableFlowable<T> obs;
    private boolean connected = false;
    private Subscription subscription;
    private ExpressionHelper<S> helper;
    private S value;

    BindingSubscriber(Function<T, S> unmaskingFunction, Consumer<Throwable> onError) {
        this.unmaskingFunction = unmaskingFunction;
        this.onError = onError;
        this.obs = null;
    }

    BindingSubscriber(Function<T, S> unmaskingFunction, ConnectableFlowable<T> obs, Consumer<Throwable> onError) {
        this.unmaskingFunction = unmaskingFunction;
        this.onError = onError;
        this.obs = obs;
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
        this.subscription.request(Long.MAX_VALUE);
    }

    public void onComplete() {
    }

    public void onError(Throwable e) {
        try {
            this.onError.accept((Object)e);
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
    }

    public void onNext(T t) {
        try {
            this.value = this.unmaskingFunction.apply(t);
            this.fireValueChangedEvent();
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public S getValue() {
        if (!this.connected && this.obs != null) {
            this.obs.connect();
            this.connected = true;
        }
        return this.value;
    }

    public boolean isValid() {
        return true;
    }

    public void invalidate() {
    }

    public ObservableList<?> getDependencies() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    public void addListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, (InvalidationListener)listener);
    }

    public void addListener(ChangeListener<? super S> listener) {
        this.helper = ExpressionHelper.addListener(this.helper, (ObservableValue)this, listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, (InvalidationListener)listener);
    }

    public void removeListener(ChangeListener<? super S> listener) {
        this.helper = ExpressionHelper.removeListener(this.helper, listener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }
}

