/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.sources;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.rxjavafx.sources.Flag;
import io.reactivex.rxjavafx.sources.MapChange;
import io.reactivex.rxjavafx.subscriptions.JavaFxSubscriptions;
import java.util.AbstractMap;
import java.util.Map;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public final class ObservableMapSource {
    private ObservableMapSource() {
    }

    public static <K, T> Observable<ObservableMap<K, T>> fromObservableMap(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> subscriber.onNext((Object)source);
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).startWith(source).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapAdds(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasAdded()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueAdded()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <K, T> Observable<Map.Entry<K, T>> fromObservableMapRemovals(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new AbstractMap.SimpleEntry<Object, Object>(c.getKey(), c.getValueRemoved()));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }

    public static <K, T> Observable<MapChange<K, T>> fromObservableMapChanges(ObservableMap<K, T> source) {
        return Observable.create(subscriber -> {
            MapChangeListener listener = c -> {
                if (c.wasRemoved()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueRemoved(), Flag.REMOVED));
                }
                if (c.wasAdded()) {
                    subscriber.onNext(new MapChange<Object, Object>(c.getKey(), c.getValueAdded(), Flag.ADDED));
                }
            };
            source.addListener(listener);
            subscriber.setDisposable(JavaFxSubscriptions.unsubscribeInEventDispatchThread(() -> source.removeListener(listener)));
        }).subscribeOn((Scheduler)JavaFxScheduler.platform());
    }
}

