/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjavafx.subscriptions;

import io.reactivex.exceptions.Exceptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.binding.Binding;

public final class CompositeBinding {
    private Set<Binding> bindings;
    private Set<CompositeBinding> compBindings;
    private boolean disposedInd;

    public CompositeBinding() {
    }

    public CompositeBinding(Binding ... bindings) {
        this.bindings = new HashSet<Binding>(Arrays.asList(bindings));
    }

    public void invalidate() {
        if (this.bindings != null) {
            this.bindings.forEach(Binding::invalidate);
        }
        if (this.compBindings != null) {
            this.compBindings.forEach(CompositeBinding::invalidate);
        }
    }

    public boolean isDisposed() {
        return this.disposedInd;
    }

    public void add(CompositeBinding b) {
        if (!this.disposedInd) {
            if (this.compBindings == null) {
                this.compBindings = new HashSet<CompositeBinding>(4);
            }
            this.compBindings.add(b);
            return;
        }
        b.dispose();
    }

    public void add(Binding b) {
        if (!this.disposedInd) {
            if (this.bindings == null) {
                this.bindings = new HashSet<Binding>(4);
            }
            this.bindings.add(b);
            return;
        }
        b.dispose();
    }

    public void remove(CompositeBinding b) {
        if (!this.disposedInd) {
            boolean unsubscribe = false;
            if (this.compBindings == null) {
                return;
            }
            unsubscribe = this.compBindings.remove(b);
            if (unsubscribe) {
                b.dispose();
            }
        }
    }

    public void remove(Binding b) {
        if (!this.disposedInd) {
            boolean unsubscribe = false;
            if (this.bindings == null) {
                return;
            }
            unsubscribe = this.bindings.remove(b);
            if (unsubscribe) {
                b.dispose();
            }
        }
    }

    public void clear() {
        if (!this.disposedInd) {
            Set<Binding> unsubscribe1 = null;
            Set<CompositeBinding> unsubscribe2 = null;
            if (this.bindings == null && this.compBindings == null) {
                return;
            }
            if (this.bindings != null) {
                unsubscribe1 = this.bindings;
                this.bindings = null;
                CompositeBinding.unsubscribeFromAll(unsubscribe1);
            }
            if (this.compBindings != null) {
                unsubscribe2 = this.compBindings;
                this.compBindings = null;
                CompositeBinding.unsubscribeFromAllComposite(unsubscribe2);
            }
        }
    }

    public void dispose() {
        if (!this.disposedInd) {
            Set<Binding> unsubscribe1 = null;
            Set<CompositeBinding> unsubscribe2 = null;
            this.disposedInd = true;
            unsubscribe1 = this.bindings;
            unsubscribe2 = this.compBindings;
            this.bindings = null;
            this.compBindings = null;
            CompositeBinding.unsubscribeFromAll(unsubscribe1);
            CompositeBinding.unsubscribeFromAllComposite(unsubscribe2);
        }
    }

    private static void unsubscribeFromAllComposite(Collection<CompositeBinding> bindings) {
        if (bindings == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (CompositeBinding b : bindings) {
            try {
                b.dispose();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        if (es != null) {
            es.forEach(Exceptions::throwIfFatal);
        }
    }

    private static void unsubscribeFromAll(Collection<Binding> bindings) {
        if (bindings == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Binding b : bindings) {
            try {
                b.dispose();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        if (es != null) {
            es.forEach(Exceptions::throwIfFatal);
        }
    }

    public boolean hasSubscriptions() {
        return !this.disposedInd && (this.bindings != null && !this.bindings.isEmpty() || this.compBindings != null && !this.compBindings.isEmpty());
    }
}

