/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.android.schedulers;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import io.reactivex.rxjava3.android.plugins.RxAndroidPlugins;
import io.reactivex.rxjava3.android.schedulers.HandlerScheduler;
import io.reactivex.rxjava3.core.Scheduler;

public final class AndroidSchedulers {
    private static final Scheduler MAIN_THREAD = RxAndroidPlugins.initMainThreadScheduler(() -> MainHolder.DEFAULT);

    public static Scheduler mainThread() {
        return RxAndroidPlugins.onMainThreadScheduler(MAIN_THREAD);
    }

    public static Scheduler from(Looper looper) {
        return AndroidSchedulers.from(looper, true);
    }

    public static Scheduler from(Looper looper, boolean async) {
        if (looper == null) {
            throw new NullPointerException("looper == null");
        }
        return AndroidSchedulers.internalFrom(looper, async);
    }

    @SuppressLint(value={"NewApi"})
    private static Scheduler internalFrom(Looper looper, boolean async) {
        if (Build.VERSION.SDK_INT < 16) {
            async = false;
        } else if (async && Build.VERSION.SDK_INT < 22) {
            Message message = Message.obtain();
            try {
                message.setAsynchronous(true);
            }
            catch (NoSuchMethodError e) {
                async = false;
            }
            message.recycle();
        }
        return new HandlerScheduler(new Handler(looper), async);
    }

    private AndroidSchedulers() {
        throw new AssertionError((Object)"No instances.");
    }

    static /* synthetic */ Scheduler access$000(Looper x0, boolean x1) {
        return AndroidSchedulers.internalFrom(x0, x1);
    }

    private static final class MainHolder {
        static final Scheduler DEFAULT = AndroidSchedulers.access$000(Looper.getMainLooper(), true);

        private MainHolder() {
        }
    }
}

