/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel;

import io.netty.util.ReferenceCountUtil;
import io.reactivex.netty.channel.AutoReleaseOperator;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.observables.ConnectableObservable;

public final class DisposableContentSource<T>
extends Observable<T> {
    private final OnSubscribeImpl<T> onSubscribe;

    private DisposableContentSource(OnSubscribeImpl<T> onSubscribe) {
        super(onSubscribe);
        this.onSubscribe = onSubscribe;
    }

    public Observable<T> autoRelease() {
        return this.lift(new AutoReleaseOperator());
    }

    public void dispose() {
        if (((OnSubscribeImpl)this.onSubscribe).disposed.compareAndSet(false, true)) {
            for (Object chunk : ((OnSubscribeImpl)this.onSubscribe).chunks) {
                ReferenceCountUtil.release(chunk);
            }
            ((OnSubscribeImpl)this.onSubscribe).chunks.clear();
        }
    }

    static <X> DisposableContentSource<X> createNew(Observable<X> source) {
        final ArrayList chunks = new ArrayList();
        ConnectableObservable replay = source.doOnNext(new Action1<X>(){

            public void call(X x) {
                chunks.add(x);
            }
        }).replay();
        return new DisposableContentSource(new OnSubscribeImpl(replay, chunks));
    }

    private static class OnSubscribeImpl<T>
    implements Observable.OnSubscribe<T> {
        private final ConnectableObservable<T> source;
        private final ArrayList<T> chunks;
        private boolean subscribed;
        private final AtomicBoolean disposed = new AtomicBoolean();

        public OnSubscribeImpl(ConnectableObservable<T> source, ArrayList<T> chunks) {
            this.source = source;
            this.chunks = chunks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(Subscriber<? super T> subscriber) {
            if (this.disposed.get()) {
                subscriber.onError((Throwable)new IllegalStateException("Content source is already disposed."));
            }
            boolean connectNow = false;
            OnSubscribeImpl onSubscribeImpl = this;
            synchronized (onSubscribeImpl) {
                if (!this.subscribed) {
                    connectNow = true;
                    this.subscribed = true;
                }
            }
            this.source.doOnNext(new Action1<T>(){

                public void call(T msg) {
                    ReferenceCountUtil.retain(msg);
                }
            }).unsafeSubscribe(subscriber);
            if (connectNow) {
                this.source.connect();
            }
        }
    }
}

