/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.pool;

import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.HostConnector;
import io.reactivex.netty.client.internal.SingleHostConnectionProvider;
import io.reactivex.netty.client.pool.PoolConfig;
import io.reactivex.netty.client.pool.PooledConnectionProvider;
import rx.Observable;
import rx.functions.Func1;

public class SingleHostPoolingProviderFactory<W, R>
implements ConnectionProviderFactory<W, R> {
    private final PoolConfig<W, R> config;

    private SingleHostPoolingProviderFactory(PoolConfig<W, R> config) {
        this.config = config;
    }

    @Override
    public ConnectionProvider<W, R> newProvider(Observable<HostConnector<W, R>> hosts) {
        return new SingleHostConnectionProvider(hosts.map(new Func1<HostConnector<W, R>, HostConnector<W, R>>(){

            public HostConnector<W, R> call(HostConnector<W, R> hc) {
                return new HostConnector(hc, PooledConnectionProvider.create(SingleHostPoolingProviderFactory.this.config, hc));
            }
        }));
    }

    public static <W, R> SingleHostPoolingProviderFactory<W, R> createUnbounded() {
        return SingleHostPoolingProviderFactory.create(new PoolConfig());
    }

    public static <W, R> SingleHostPoolingProviderFactory<W, R> createBounded(int maxConnections) {
        return SingleHostPoolingProviderFactory.create(new PoolConfig().maxConnections(maxConnections));
    }

    public static <W, R> SingleHostPoolingProviderFactory<W, R> create(PoolConfig<W, R> config) {
        return new SingleHostPoolingProviderFactory<W, R>(config);
    }
}

