/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.util;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Subscriber;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Action0;
import rx.internal.util.BackpressureDrainManager;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;

@Experimental
public class UnicastBufferingSubject<T>
extends Subject<T, T> {
    private final State<T> state;

    protected UnicastBufferingSubject(Observable.OnSubscribe<T> onSubscribe, State<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    public static <T> UnicastBufferingSubject<T> create(long bufferSize) {
        final State state = new State(bufferSize);
        return new UnicastBufferingSubject(new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                state.registerSubscriber(subscriber);
            }
        }, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        State<T> state = this.state;
        synchronized (state) {
            if (null != ((State)this.state).producer) {
                return ((State)this.state).producer.isTerminated();
            }
            return ((State)this.state).terminatedBeforeSubscribe;
        }
    }

    public boolean hasObservers() {
        return null != ((State)this.state).subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCompleted() {
        BackpressureDrainManager p = null;
        State<T> state = this.state;
        synchronized (state) {
            if (null != ((State)this.state).producer) {
                p = ((State)this.state).producer;
            } else {
                ((State)this.state).terminatedBeforeSubscribe = true;
                ((State)this.state).errorBeforeSubscribe = null;
            }
        }
        if (null != p) {
            p.terminateAndDrain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable e) {
        BackpressureDrainManager p = null;
        State<T> state = this.state;
        synchronized (state) {
            if (null != ((State)this.state).producer) {
                p = ((State)this.state).producer;
            } else {
                ((State)this.state).terminatedBeforeSubscribe = true;
                ((State)this.state).errorBeforeSubscribe = e;
            }
        }
        if (null != p) {
            p.terminateAndDrain(e);
        }
    }

    public void onNext(T t) {
        try {
            this.addNext(t);
        }
        catch (MissingBackpressureException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNext(T next) throws MissingBackpressureException {
        long newSize;
        long currentSize;
        if (this.isTerminated()) {
            throw new IllegalStateException("Observable is already completed.");
        }
        do {
            if ((newSize = (currentSize = ((State)this.state).currentSize.get()) + 1L) <= ((State)this.state).maxBufferedCount) continue;
            throw new MissingBackpressureException("Max buffer limit exceeded. Current size: " + currentSize);
        } while (!((State)this.state).currentSize.compareAndSet(currentSize, newSize));
        ((State)this.state).nexts.add(next);
        BackpressureDrainManager p = null;
        State<T> state = this.state;
        synchronized (state) {
            if (null != ((State)this.state).producer) {
                p = ((State)this.state).producer;
            }
        }
        if (null != p) {
            p.drain();
        }
    }

    public boolean offerNext(T next) {
        try {
            this.addNext(next);
            return true;
        }
        catch (MissingBackpressureException e) {
            return false;
        }
    }

    private static final class State<T> {
        private final ConcurrentLinkedQueue<T> nexts;
        private final BackpressureQueueCallbackImpl queueCallback;
        private final AtomicLong currentSize = new AtomicLong();
        private final long maxBufferedCount;
        private volatile Subscriber<? super T> subscriber;
        private volatile BackpressureDrainManager producer;
        private volatile Throwable errorBeforeSubscribe;
        private volatile boolean terminatedBeforeSubscribe;

        private State(long maxBufferedCount) {
            this.maxBufferedCount = maxBufferedCount;
            this.nexts = new ConcurrentLinkedQueue();
            this.queueCallback = new BackpressureQueueCallbackImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerSubscriber(Subscriber<? super T> subscriber) {
            boolean _shdSubscribe = false;
            boolean _terminated = false;
            Throwable _terminalError = null;
            BackpressureDrainManager p = null;
            State state = this;
            synchronized (state) {
                if (null == this.subscriber) {
                    this.subscriber = subscriber;
                    _shdSubscribe = true;
                    _terminated = this.terminatedBeforeSubscribe;
                    _terminalError = this.errorBeforeSubscribe;
                    this.producer = p = new BackpressureDrainManager((BackpressureDrainManager.BackpressureQueueCallback)this.queueCallback);
                }
            }
            if (_shdSubscribe) {
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void call() {
                        State state = State.this;
                        synchronized (state) {
                            State.this.subscriber = null;
                            State.this.producer = null;
                        }
                    }
                }));
                subscriber.setProducer(p);
                if (_terminated) {
                    p.terminateAndDrain(_terminalError);
                }
            } else {
                subscriber.onError((Throwable)new IllegalStateException("Only one subscriber is allowed."));
            }
        }

        private class BackpressureQueueCallbackImpl
        implements BackpressureDrainManager.BackpressureQueueCallback {
            private BackpressureQueueCallbackImpl() {
            }

            public Object peek() {
                return State.this.nexts.peek();
            }

            public Object poll() {
                Object poll = State.this.nexts.poll();
                if (null != poll) {
                    State.this.currentSize.decrementAndGet();
                }
                return poll;
            }

            public boolean accept(Object next) {
                Object t = next;
                State.this.subscriber.onNext(t);
                return false;
            }

            public void complete(Throwable exception) {
                if (null == exception) {
                    State.this.subscriber.onCompleted();
                } else {
                    State.this.subscriber.onError(exception);
                }
            }
        }
    }
}

