/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.events;

import io.reactivex.netty.events.EventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import io.reactivex.netty.protocol.http.client.events.SafeHttpClientEventsListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventPublisher;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.subscriptions.CompositeSubscription;

public final class HttpClientEventPublisher
extends HttpClientEventsListener
implements EventSource<HttpClientEventsListener>,
EventPublisher {
    private static final Action1<HttpClientEventsListener> REQUEST_SUBMIT_ACTION = new Action1<HttpClientEventsListener>(){

        public void call(HttpClientEventsListener listener) {
            listener.onRequestSubmitted();
        }
    };
    private static final Action1<HttpClientEventsListener> REQUEST_WRITE_START_ACTION = new Action1<HttpClientEventsListener>(){

        public void call(HttpClientEventsListener listener) {
            listener.onRequestWriteStart();
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> REQUEST_WRITE_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onRequestWriteComplete(duration, timeUnit);
        }
    };
    private static final Action4<HttpClientEventsListener, Long, TimeUnit, Throwable> REQUEST_WRITE_FAILED_ACTION = new Action4<HttpClientEventsListener, Long, TimeUnit, Throwable>(){

        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit, Throwable t) {
            listener.onRequestWriteFailed(duration, timeUnit, t);
        }
    };
    private static final Action4<HttpClientEventsListener, Long, TimeUnit, Integer> RESP_HEADER_RECIEVED_ACTION = new Action4<HttpClientEventsListener, Long, TimeUnit, Integer>(){

        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit, Integer responseCode) {
            listener.onResponseHeadersReceived(responseCode, duration, timeUnit);
        }
    };
    private static final Action1<HttpClientEventsListener> RESP_CONTENT_RECIEVED_ACTION = new Action1<HttpClientEventsListener>(){

        public void call(HttpClientEventsListener listener) {
            listener.onResponseContentReceived();
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> RESP_RECIEVE_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onResponseReceiveComplete(duration, timeUnit);
        }
    };
    private static final Action2<HttpClientEventsListener, Throwable> RESP_FAILED_ACTION = new Action2<HttpClientEventsListener, Throwable>(){

        public void call(HttpClientEventsListener listener, Throwable t) {
            listener.onResponseFailed(t);
        }
    };
    private static final Action3<HttpClientEventsListener, Long, TimeUnit> PROCESSING_COMPLETE_ACTION = new Action3<HttpClientEventsListener, Long, TimeUnit>(){

        public void call(HttpClientEventsListener listener, Long duration, TimeUnit timeUnit) {
            listener.onRequestProcessingComplete(duration, timeUnit);
        }
    };
    private final ListenersHolder<HttpClientEventsListener> listeners;
    private final TcpClientEventPublisher tcpDelegate;

    public HttpClientEventPublisher() {
        this.listeners = new ListenersHolder();
        this.tcpDelegate = new TcpClientEventPublisher();
    }

    private HttpClientEventPublisher(ListenersHolder<HttpClientEventsListener> l, TcpClientEventPublisher tcpDelegate) {
        this.listeners = new ListenersHolder(l);
        this.tcpDelegate = tcpDelegate;
    }

    @Override
    public void onRequestSubmitted() {
        this.listeners.invokeListeners(REQUEST_SUBMIT_ACTION);
    }

    @Override
    public void onRequestWriteStart() {
        this.listeners.invokeListeners(REQUEST_WRITE_START_ACTION);
    }

    @Override
    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(REQUEST_WRITE_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(REQUEST_WRITE_FAILED_ACTION, duration, timeUnit, throwable);
    }

    @Override
    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(RESP_HEADER_RECIEVED_ACTION, duration, timeUnit, (Object)responseCode);
    }

    @Override
    public void onResponseContentReceived() {
        this.listeners.invokeListeners(RESP_CONTENT_RECIEVED_ACTION);
    }

    @Override
    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(RESP_RECIEVE_COMPLETE_ACTION, duration, timeUnit);
    }

    @Override
    public void onResponseFailed(Throwable throwable) {
        this.listeners.invokeListeners(RESP_FAILED_ACTION, (Object)throwable);
    }

    @Override
    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(PROCESSING_COMPLETE_ACTION, duration, timeUnit);
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectionCloseFailed(duration, timeUnit, throwable);
    }

    public void onConnectStart() {
        this.tcpDelegate.onConnectStart();
    }

    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectSuccess(duration, timeUnit);
    }

    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onConnectFailed(duration, timeUnit, throwable);
    }

    public void onPoolReleaseStart() {
        this.tcpDelegate.onPoolReleaseStart();
    }

    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolReleaseSuccess(duration, timeUnit);
    }

    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolReleaseFailed(duration, timeUnit, throwable);
    }

    public void onPooledConnectionEviction() {
        this.tcpDelegate.onPooledConnectionEviction();
    }

    public void onPooledConnectionReuse() {
        this.tcpDelegate.onPooledConnectionReuse();
    }

    public void onPoolAcquireStart() {
        this.tcpDelegate.onPoolAcquireStart();
    }

    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onPoolAcquireSuccess(duration, timeUnit);
    }

    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onPoolAcquireFailed(duration, timeUnit, throwable);
    }

    public void onByteRead(long bytesRead) {
        this.tcpDelegate.onByteRead(bytesRead);
    }

    public void onByteWritten(long bytesWritten) {
        this.tcpDelegate.onByteWritten(bytesWritten);
    }

    public void onFlushStart() {
        this.tcpDelegate.onFlushStart();
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onFlushComplete(duration, timeUnit);
    }

    public void onWriteStart() {
        this.tcpDelegate.onWriteStart();
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onWriteSuccess(duration, timeUnit);
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onWriteFailed(duration, timeUnit, throwable);
    }

    public void onConnectionCloseStart() {
        this.tcpDelegate.onConnectionCloseStart();
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onConnectionCloseSuccess(duration, timeUnit);
    }

    public void onCustomEvent(Object event) {
        this.tcpDelegate.onCustomEvent(event);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit);
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, duration, timeUnit, throwable);
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        this.tcpDelegate.onCustomEvent(event, throwable);
    }

    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    public Subscription subscribe(HttpClientEventsListener listener) {
        if (!SafeEventListener.class.isAssignableFrom(((Object)((Object)listener)).getClass())) {
            listener = new SafeHttpClientEventsListener(listener);
        }
        CompositeSubscription cs = new CompositeSubscription();
        cs.add(this.listeners.subscribe((EventListener)listener));
        HttpClientEventsListener tcpListener = listener;
        if (listener instanceof SafeHttpClientEventsListener) {
            tcpListener = ((SafeHttpClientEventsListener)listener).unwrap();
        }
        cs.add(this.tcpDelegate.subscribe((TcpClientEventListener)tcpListener));
        return cs;
    }

    public EventSource<TcpClientEventListener> asTcpEventSource() {
        return new EventSource<TcpClientEventListener>(){

            public Subscription subscribe(TcpClientEventListener listener) {
                if (listener instanceof HttpClientEventsListener) {
                    return HttpClientEventPublisher.this.subscribe((HttpClientEventsListener)listener);
                }
                return HttpClientEventPublisher.this.tcpDelegate.subscribe(listener);
            }
        };
    }

    public HttpClientEventPublisher copy() {
        return new HttpClientEventPublisher((ListenersHolder<HttpClientEventsListener>)this.listeners.copy(), this.tcpDelegate.copy());
    }

    ListenersHolder<HttpClientEventsListener> getListeners() {
        return this.listeners;
    }

    TcpClientEventListener getTcpDelegate() {
        return this.tcpDelegate;
    }
}

