/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.http.client.events.HttpClientEventsListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeHttpClientEventsListener
extends HttpClientEventsListener
implements SafeEventListener {
    private final HttpClientEventsListener delegate;
    private final AtomicBoolean completed = new AtomicBoolean();

    public SafeHttpClientEventsListener(HttpClientEventsListener delegate) {
        this.delegate = delegate;
    }

    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    @Override
    public void onRequestSubmitted() {
        if (!this.completed.get()) {
            this.delegate.onRequestSubmitted();
        }
    }

    @Override
    public void onRequestWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteStart();
        }
    }

    @Override
    public void onRequestWriteComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteComplete(duration, timeUnit);
        }
    }

    @Override
    public void onRequestWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onRequestWriteFailed(duration, timeUnit, throwable);
        }
    }

    @Override
    public void onResponseHeadersReceived(int responseCode, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onResponseHeadersReceived(responseCode, duration, timeUnit);
        }
    }

    @Override
    public void onResponseContentReceived() {
        if (!this.completed.get()) {
            this.delegate.onResponseContentReceived();
        }
    }

    @Override
    public void onResponseReceiveComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onResponseReceiveComplete(duration, timeUnit);
        }
    }

    @Override
    public void onResponseFailed(Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onResponseFailed(throwable);
        }
    }

    @Override
    public void onRequestProcessingComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onRequestProcessingComplete(duration, timeUnit);
        }
    }

    public void onConnectStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectStart();
        }
    }

    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectSuccess(duration, timeUnit);
        }
    }

    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectFailed(duration, timeUnit, throwable);
        }
    }

    public void onPoolReleaseStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseStart();
        }
    }

    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseSuccess(duration, timeUnit);
        }
    }

    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseFailed(duration, timeUnit, throwable);
        }
    }

    public void onPooledConnectionEviction() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionEviction();
        }
    }

    public void onPooledConnectionReuse() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionReuse();
        }
    }

    public void onPoolAcquireStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireStart();
        }
    }

    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireSuccess(duration, timeUnit);
        }
    }

    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireFailed(duration, timeUnit, throwable);
        }
    }

    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    public HttpClientEventsListener unwrap() {
        return this.delegate;
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeHttpClientEventsListener)) {
            return false;
        }
        SafeHttpClientEventsListener that = (SafeHttpClientEventsListener)((Object)o);
        return !(this.delegate == null ? that.delegate != null : !((Object)((Object)this.delegate)).equals((Object)that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? ((Object)((Object)this.delegate)).hashCode() : 0;
    }
}

