/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.reactivex.netty.channel.AllocatingTransformer;
import io.reactivex.netty.channel.ChannelOperations;
import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.channel.MarkAwarePipeline;
import io.reactivex.netty.protocol.http.HttpHandlerNames;
import io.reactivex.netty.protocol.http.TrailingHeaders;
import io.reactivex.netty.protocol.http.server.ContentWriterImpl;
import io.reactivex.netty.protocol.http.server.FailedContentWriter;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.ResponseContentWriter;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;
import io.reactivex.netty.protocol.http.sse.server.ServerSentEventEncoder;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandler;
import io.reactivex.netty.protocol.http.ws.server.WebSocketHandshaker;
import java.util.Date;
import java.util.List;
import java.util.Set;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class HttpServerResponseImpl<C>
extends HttpServerResponse<C> {
    private final State<C> state;

    private HttpServerResponseImpl(final State<C> state) {
        super(new Observable.OnSubscribe<Void>(){

            public void call(Subscriber<? super Void> subscriber) {
                state.sendHeaders().unsafeSubscribe(subscriber);
            }
        });
        this.state = state;
    }

    @Override
    public HttpResponseStatus getStatus() {
        return ((State)this.state).headers.status();
    }

    @Override
    public boolean containsHeader(CharSequence name) {
        return ((State)this.state).headers.headers().contains(name);
    }

    @Override
    public boolean containsHeader(CharSequence name, CharSequence value, boolean ignoreCaseValue) {
        return ((State)this.state).headers.headers().contains(name, value, ignoreCaseValue);
    }

    @Override
    public String getHeader(CharSequence name) {
        return ((State)this.state).headers.headers().get(name);
    }

    @Override
    public String getHeader(CharSequence name, String defaultValue) {
        return ((State)this.state).headers.headers().get(name, defaultValue);
    }

    @Override
    public List<String> getAllHeaderValues(CharSequence name) {
        return ((State)this.state).headers.headers().getAll(name);
    }

    @Override
    public long getDateHeader(CharSequence name) {
        return ((State)this.state).headers.headers().getTimeMillis(name);
    }

    @Override
    public long getDateHeader(CharSequence name, long defaultValue) {
        return ((State)this.state).headers.headers().getTimeMillis(name, defaultValue);
    }

    @Override
    public int getIntHeader(CharSequence name) {
        return ((State)this.state).headers.headers().getInt(name);
    }

    @Override
    public int getIntHeader(CharSequence name, int defaultValue) {
        return ((State)this.state).headers.headers().getInt(name, defaultValue);
    }

    @Override
    public Set<String> getHeaderNames() {
        return ((State)this.state).headers.headers().names();
    }

    @Override
    public HttpServerResponse<C> addHeader(CharSequence name, Object value) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().add(name, value);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> addCookie(Cookie cookie) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode(cookie));
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> addDateHeader(CharSequence name, Date value) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().add(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> addDateHeader(CharSequence name, Iterable<Date> values) {
        if (((State)this.state).allowUpdate()) {
            for (Date value : values) {
                ((State)this.state).headers.headers().add(name, (Object)value);
            }
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> addHeader(CharSequence name, Iterable<Object> values) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().add(name, values);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setDateHeader(CharSequence name, Date value) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().set(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setHeader(CharSequence name, Object value) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().set(name, value);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setDateHeader(CharSequence name, Iterable<Date> values) {
        if (((State)this.state).allowUpdate()) {
            for (Date value : values) {
                ((State)this.state).headers.headers().set(name, (Object)value);
            }
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setHeader(CharSequence name, Iterable<Object> values) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().set(name, values);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> removeHeader(CharSequence name) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.headers().remove(name);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setStatus(HttpResponseStatus status) {
        if (((State)this.state).allowUpdate()) {
            ((State)this.state).headers.setStatus(status);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> setTransferEncodingChunked() {
        if (((State)this.state).allowUpdate()) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)((State)this.state).headers, (boolean)true);
        }
        return this;
    }

    @Override
    public HttpServerResponse<C> flushOnlyOnReadComplete() {
        ((State)this.state).connection.unsafeNettyChannel().attr(ChannelOperations.FLUSH_ONLY_ON_READ_COMPLETE).set((Object)true);
        return this;
    }

    @Override
    public ResponseContentWriter<C> sendHeaders() {
        return this.state.sendHeaders();
    }

    @Override
    public HttpServerResponse<ServerSentEvent> transformToServerSentEvents() {
        this.markAwarePipeline().addAfter(HttpHandlerNames.HttpServerEncoder.getName(), HttpHandlerNames.SseServerCodec.getName(), (ChannelHandler)new ServerSentEventEncoder());
        return this._cast();
    }

    @Override
    public <CC> HttpServerResponse<CC> transformContent(AllocatingTransformer<CC, C> transformer) {
        Connection transformedC = ((State)this.state).connection.transformWrite(transformer);
        return new HttpServerResponseImpl(new State(this.state, transformedC));
    }

    @Override
    public WebSocketHandshaker acceptWebSocketUpgrade(WebSocketHandler handler) {
        return WebSocketHandshaker.isUpgradeRequested(((State)this.state).request) ? WebSocketHandshaker.newHandshaker(((State)this.state).request, this, handler) : WebSocketHandshaker.newErrorHandshaker(new IllegalStateException("WebSocket upgrade was not requested."));
    }

    @Override
    public Observable<Void> dispose() {
        return Observable.defer((Func0)new Func0<Observable<Void>>(){

            public Observable<Void> call() {
                return (HttpServerResponseImpl.this.state.allowUpdate() ? HttpServerResponseImpl.this.write(Observable.empty()) : Observable.empty()).doOnSubscribe(new Action0(){

                    public void call() {
                        HttpServerResponseImpl.this.state.connection.getResettableChannelPipeline().reset();
                    }
                });
            }
        });
    }

    @Override
    public Channel unsafeNettyChannel() {
        return ((State)this.state).connection.unsafeNettyChannel();
    }

    @Override
    public Connection<?, ?> unsafeConnection() {
        return ((State)this.state).connection;
    }

    @Override
    public ResponseContentWriter<C> write(Observable<C> msgs) {
        return this.state.sendHeaders().write(msgs);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> write(Observable<C> contentSource, Func0<T> trailerFactory, Func2<T, C, T> trailerMutator) {
        return this.state.sendHeaders().write(contentSource, trailerFactory, trailerMutator);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> write(Observable<C> contentSource, Func0<T> trailerFactory, Func2<T, C, T> trailerMutator, Func1<C, Boolean> flushSelector) {
        return this.state.sendHeaders().write(contentSource, trailerFactory, trailerMutator, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> write(Observable<C> msgs, Func1<C, Boolean> flushSelector) {
        return this.state.sendHeaders().write(msgs, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> writeAndFlushOnEach(Observable<C> msgs) {
        return this.state.sendHeaders().writeAndFlushOnEach(msgs);
    }

    @Override
    public ResponseContentWriter<C> writeString(Observable<String> msgs) {
        return this.state.sendHeaders().writeString(msgs);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> writeString(Observable<String> contentSource, Func0<T> trailerFactory, Func2<T, String, T> trailerMutator) {
        return this.state.sendHeaders().writeString(contentSource, trailerFactory, trailerMutator);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> writeString(Observable<String> contentSource, Func0<T> trailerFactory, Func2<T, String, T> trailerMutator, Func1<String, Boolean> flushSelector) {
        return this.state.sendHeaders().writeString(contentSource, trailerFactory, trailerMutator, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> writeString(Observable<String> msgs, Func1<String, Boolean> flushSelector) {
        return this.state.sendHeaders().writeString(msgs, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> writeStringAndFlushOnEach(Observable<String> msgs) {
        return this.state.sendHeaders().writeStringAndFlushOnEach(msgs);
    }

    @Override
    public ResponseContentWriter<C> writeBytes(Observable<byte[]> msgs) {
        return this.state.sendHeaders().writeBytes(msgs);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> writeBytes(Observable<byte[]> contentSource, Func0<T> trailerFactory, Func2<T, byte[], T> trailerMutator) {
        return this.state.sendHeaders().writeBytes(contentSource, trailerFactory, trailerMutator);
    }

    @Override
    public <T extends TrailingHeaders> Observable<Void> writeBytes(Observable<byte[]> contentSource, Func0<T> trailerFactory, Func2<T, byte[], T> trailerMutator, Func1<byte[], Boolean> flushSelector) {
        return this.state.sendHeaders().writeBytes(contentSource, trailerFactory, trailerMutator, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> writeBytes(Observable<byte[]> msgs, Func1<byte[], Boolean> flushSelector) {
        return this.state.sendHeaders().writeBytes(msgs, flushSelector);
    }

    @Override
    public ResponseContentWriter<C> writeBytesAndFlushOnEach(Observable<byte[]> msgs) {
        return this.state.sendHeaders().writeBytesAndFlushOnEach(msgs);
    }

    public static <T> HttpServerResponse<T> create(HttpServerRequest<?> request, Connection connection, HttpResponse headers) {
        State newState = new State(headers, connection, request);
        return new HttpServerResponseImpl(newState);
    }

    private <CC> HttpServerResponse<CC> _cast() {
        return this;
    }

    private MarkAwarePipeline markAwarePipeline() {
        return ((State)this.state).connection.getResettableChannelPipeline().markIfNotYetMarked();
    }

    private static final class HeaderSentStateHolder
    implements Func0 {
        private boolean headersSent = false;

        private HeaderSentStateHolder() {
        }

        public Object call() {
            return this.headersSent;
        }
    }

    private static class State<T> {
        private final HttpResponse headers;
        private final Connection connection;
        private final HttpServerRequest<?> request;
        private final HeaderSentStateHolder sentStateHolder;

        private State(HttpResponse headers, Connection connection, HttpServerRequest<?> request) {
            this.headers = headers;
            this.connection = connection;
            this.request = request;
            this.sentStateHolder = new HeaderSentStateHolder();
        }

        public State(State<?> state, Connection connection) {
            this.headers = state.headers;
            this.request = state.request;
            this.sentStateHolder = state.sentStateHolder;
            this.connection = connection;
        }

        private boolean allowUpdate() {
            return !this.sentStateHolder.headersSent;
        }

        public ResponseContentWriter<T> sendHeaders() {
            if (this.allowUpdate()) {
                this.sentStateHolder.headersSent = true;
                return new ContentWriterImpl(this.connection, this.headers);
            }
            return new FailedContentWriter();
        }
    }
}

