/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.client.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeTcpClientEventListener
extends TcpClientEventListener
implements SafeEventListener {
    private final TcpClientEventListener delegate;
    private final AtomicBoolean completed = new AtomicBoolean();

    public SafeTcpClientEventListener(TcpClientEventListener delegate) {
        this.delegate = delegate;
    }

    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    public void onConnectStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectStart();
        }
    }

    public void onConnectSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectSuccess(duration, timeUnit);
        }
    }

    public void onConnectFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectFailed(duration, timeUnit, throwable);
        }
    }

    public void onPoolReleaseStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseStart();
        }
    }

    public void onPoolReleaseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseSuccess(duration, timeUnit);
        }
    }

    public void onPoolReleaseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolReleaseFailed(duration, timeUnit, throwable);
        }
    }

    public void onPooledConnectionEviction() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionEviction();
        }
    }

    public void onPooledConnectionReuse() {
        if (!this.completed.get()) {
            this.delegate.onPooledConnectionReuse();
        }
    }

    public void onPoolAcquireStart() {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireStart();
        }
    }

    public void onPoolAcquireSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireSuccess(duration, timeUnit);
        }
    }

    public void onPoolAcquireFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onPoolAcquireFailed(duration, timeUnit, throwable);
        }
    }

    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeTcpClientEventListener)) {
            return false;
        }
        SafeTcpClientEventListener that = (SafeTcpClientEventListener)((Object)o);
        return !(this.delegate == null ? that.delegate != null : !((Object)((Object)this.delegate)).equals((Object)that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? ((Object)((Object)this.delegate)).hashCode() : 0;
    }
}

