/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observables.SwingObservable;
import rx.subscriptions.SwingSubscriptions;

public enum KeyEventSource {


    public static Observable<KeyEvent> fromKeyEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<KeyEvent>(){

            public void call(final Subscriber<? super KeyEvent> subscriber) {
                SwingObservable.assertEventDispatchThread();
                final KeyListener listener = new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void keyReleased(KeyEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void keyTyped(KeyEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addKeyListener(listener);
                subscriber.add(SwingSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        component.removeKeyListener(listener);
                    }
                }));
            }
        });
    }

    public static Observable<Set<Integer>> currentlyPressedKeysOf(Component component) {
        Observable filteredKeyEvents = KeyEventSource.fromKeyEventsOf(component).filter((Func1)new Func1<KeyEvent, Boolean>(){

            public Boolean call(KeyEvent event) {
                return event.getID() == 401 || event.getID() == 402;
            }
        });
        class CollectKeys
        implements Func2<Set<Integer>, KeyEvent, Set<Integer>> {
            CollectKeys() {
            }

            public Set<Integer> call(Set<Integer> pressedKeys, KeyEvent event) {
                HashSet<Integer> afterEvent = new HashSet<Integer>(pressedKeys);
                switch (event.getID()) {
                    case 401: {
                        afterEvent.add(event.getKeyCode());
                        break;
                    }
                    case 402: {
                        afterEvent.remove(event.getKeyCode());
                        break;
                    }
                }
                return afterEvent;
            }
        }
        return filteredKeyEvents.scan(Collections.emptySet(), (Func2)new CollectKeys());
    }
}

