/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func2;
import rx.observables.SwingObservable;
import rx.subscriptions.SwingSubscriptions;

public enum MouseEventSource {


    public static Observable<MouseEvent> fromMouseEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<MouseEvent>(){

            public void call(final Subscriber<? super MouseEvent> subscriber) {
                SwingObservable.assertEventDispatchThread();
                final MouseListener listener = new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void mousePressed(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void mouseReleased(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addMouseListener(listener);
                subscriber.add(SwingSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        component.removeMouseListener(listener);
                    }
                }));
            }
        });
    }

    public static Observable<MouseEvent> fromMouseMotionEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<MouseEvent>(){

            public void call(final Subscriber<? super MouseEvent> subscriber) {
                SwingObservable.assertEventDispatchThread();
                final MouseMotionListener listener = new MouseMotionListener(){

                    @Override
                    public void mouseDragged(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void mouseMoved(MouseEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addMouseMotionListener(listener);
                subscriber.add(SwingSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        component.removeMouseMotionListener(listener);
                    }
                }));
            }
        });
    }

    public static Observable<Point> fromRelativeMouseMotion(Component component) {
        Observable<MouseEvent> events = MouseEventSource.fromMouseMotionEventsOf(component);
        return Observable.zip(events, (Observable)events.skip(1), (Func2)new Func2<MouseEvent, MouseEvent, Point>(){

            public Point call(MouseEvent ev1, MouseEvent ev2) {
                return new Point(ev2.getX() - ev1.getX(), ev2.getY() - ev1.getY());
            }
        });
    }
}

