/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.functions.Action0;
import rx.schedulers.SwingScheduler;

final class SwingTestHelper {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile Throwable error;

    private SwingTestHelper() {
    }

    public static SwingTestHelper create() {
        return new SwingTestHelper();
    }

    public SwingTestHelper runInEventDispatchThread(final Action0 action) {
        Scheduler.Worker inner = SwingScheduler.getInstance().createWorker();
        inner.schedule(new Action0(){

            public void call() {
                try {
                    action.call();
                }
                catch (Throwable e) {
                    SwingTestHelper.this.error = e;
                }
                SwingTestHelper.this.latch.countDown();
            }
        });
        return this;
    }

    public void awaitTerminal() throws Throwable {
        this.latch.await();
        if (this.error != null) {
            throw this.error;
        }
    }

    public void awaitTerminal(long timeout, TimeUnit unit) throws Throwable {
        this.latch.await(timeout, unit);
        if (this.error != null) {
            throw this.error;
        }
    }
}

