/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.observables.SwingObservable;
import rx.subscriptions.SwingSubscriptions;

public enum AbstractButtonSource {


    public static Observable<ActionEvent> fromActionOf(final AbstractButton button) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ActionEvent>(){

            public void call(final Subscriber<? super ActionEvent> subscriber) {
                SwingObservable.assertEventDispatchThread();
                final ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        subscriber.onNext((Object)e);
                    }
                };
                button.addActionListener(listener);
                subscriber.add(SwingSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        button.removeActionListener(listener);
                    }
                }));
            }
        });
    }
}

