/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.observables.SwingObservable;
import rx.subscriptions.SwingSubscriptions;

public enum ComponentEventSource {


    public static Observable<ComponentEvent> fromComponentEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ComponentEvent>(){

            public void call(final Subscriber<? super ComponentEvent> subscriber) {
                SwingObservable.assertEventDispatchThread();
                final ComponentListener listener = new ComponentListener(){

                    @Override
                    public void componentHidden(ComponentEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void componentMoved(ComponentEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void componentResized(ComponentEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void componentShown(ComponentEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addComponentListener(listener);
                subscriber.add(SwingSubscriptions.unsubscribeInEventDispatchThread(new Action0(){

                    public void call() {
                        component.removeComponentListener(listener);
                    }
                }));
            }
        });
    }

    public static Observable<Dimension> fromResizing(Component component) {
        return ComponentEventSource.fromComponentEventsOf(component).filter((Func1)Predicate.RESIZED).map((Func1)new Func1<ComponentEvent, Dimension>(){

            public Dimension call(ComponentEvent event) {
                return event.getComponent().getSize();
            }
        });
    }

    public static enum Predicate implements Func1<ComponentEvent, Boolean>
    {
        RESIZED(101),
        HIDDEN(103),
        MOVED(100),
        SHOWN(102);

        private final int id;

        private Predicate(int id) {
            this.id = id;
        }

        public Boolean call(ComponentEvent event) {
            return event.getID() == this.id;
        }
    }
}

