/*
 * Decompiled with CFR 0.152.
 */
package rx.schedulers;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.BooleanSubscription;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class SwingScheduler
extends Scheduler {
    private static final SwingScheduler INSTANCE = new SwingScheduler();

    public static SwingScheduler getInstance() {
        return INSTANCE;
    }

    SwingScheduler() {
    }

    public Scheduler.Worker createWorker() {
        return new InnerSwingScheduler();
    }

    private static void assertThatTheDelayIsValidForTheSwingTimer(long delay) {
        if (delay < 0L || delay > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("The swing timer only accepts non-negative delays up to %d milliseconds.", Integer.MAX_VALUE));
        }
    }

    private static class InnerSwingScheduler
    extends Scheduler.Worker {
        private final CompositeSubscription innerSubscription = new CompositeSubscription();

        private InnerSwingScheduler() {
        }

        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }

        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            long delay = Math.max(0L, unit.toMillis(delayTime));
            SwingScheduler.assertThatTheDelayIsValidForTheSwingTimer(delay);
            final BooleanSubscription s = BooleanSubscription.create();
            class ExecuteOnceAction
            implements ActionListener {
                private Timer timer;

                ExecuteOnceAction() {
                }

                private void setTimer(Timer timer) {
                    this.timer = timer;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.timer.stop();
                    if (InnerSwingScheduler.this.innerSubscription.isUnsubscribed() || s.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                    InnerSwingScheduler.this.innerSubscription.remove((Subscription)s);
                }
            }
            ExecuteOnceAction executeOnce = new ExecuteOnceAction();
            final Timer timer = new Timer((int)delay, executeOnce);
            executeOnce.setTimer(timer);
            timer.start();
            this.innerSubscription.add((Subscription)s);
            return Subscriptions.create((Action0)new Action0(){

                public void call() {
                    timer.stop();
                    s.unsubscribe();
                    InnerSwingScheduler.this.innerSubscription.remove((Subscription)s);
                }
            });
        }

        public Subscription schedule(final Action0 action) {
            final BooleanSubscription s = BooleanSubscription.create();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (InnerSwingScheduler.this.innerSubscription.isUnsubscribed() || s.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                    InnerSwingScheduler.this.innerSubscription.remove((Subscription)s);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
            this.innerSubscription.add((Subscription)s);
            return Subscriptions.create((Action0)new Action0(){

                public void call() {
                    s.unsubscribe();
                    InnerSwingScheduler.this.innerSubscription.remove((Subscription)s);
                }
            });
        }
    }
}

