/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum ChangeEventSource {

    private static final String ADD_CHANGE_LISTENER_METHOD_NAME = "addChangeListener";
    private static final String REMOVE_CHANGE_LISTENER_METHOD_NAME = "removeChangeListener";

    public static Observable<ChangeEvent> fromChangeEventsOf(final Object changeEventSource) {
        ChangeEventSource.checkHasChangeListenerSupport(changeEventSource);
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ChangeEvent>(){

            public void call(final Subscriber<? super ChangeEvent> subscriber) {
                final ChangeListener listener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                ChangeEventSource.addChangeListener(changeEventSource, listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        ChangeEventSource.removeChangeListener(changeEventSource, listener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }

    private static void checkHasChangeListenerSupport(Object object) {
        ChangeEventSource.checkPublicMethodExists(object, ADD_CHANGE_LISTENER_METHOD_NAME, ChangeListener.class);
        ChangeEventSource.checkPublicMethodExists(object, REMOVE_CHANGE_LISTENER_METHOD_NAME, ChangeListener.class);
    }

    private static void checkPublicMethodExists(Object object, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = object.getClass().getMethod(methodName, parameterTypes);
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Class '" + object.getClass().getName() + "' has not the expected signature to support change listeners in " + ChangeEventSource.class.getName() + ". " + methodName + " is not accessible.");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class '" + object.getClass().getName() + "' has not the expected signature to support change listeners in " + ChangeEventSource.class.getName(), e);
        }
    }

    private static void addChangeListener(Object object, ChangeListener changeListener) {
        ChangeEventSource.callChangeListenerMethodViaReflection(object, ADD_CHANGE_LISTENER_METHOD_NAME, changeListener);
    }

    private static void removeChangeListener(Object object, ChangeListener changeListener) {
        ChangeEventSource.callChangeListenerMethodViaReflection(object, REMOVE_CHANGE_LISTENER_METHOD_NAME, changeListener);
    }

    private static void callChangeListenerMethodViaReflection(Object object, String methodName, ChangeListener changeListener) {
        try {
            object.getClass().getMethod(methodName, ChangeListener.class).invoke(object, changeListener);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Call of " + methodName + " via reflection failed. Does class " + object.getClass().getName() + " support change listeners?", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Call of " + methodName + " via reflection failed.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Call of " + methodName + " via reflection failed. Does class " + object.getClass().getName() + " support change listeners?", e);
        }
    }
}

