/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum FocusEventSource {


    public static Observable<FocusEvent> fromFocusEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<FocusEvent>(){

            public void call(final Subscriber<? super FocusEvent> subscriber) {
                final FocusListener listener = new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void focusLost(FocusEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addFocusListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeFocusListener(listener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }

    public static enum Predicate implements Func1<FocusEvent, Boolean>
    {
        FOCUS_GAINED(1004),
        FOCUS_LOST(1005);

        private final int id;

        private Predicate(int id) {
            this.id = id;
        }

        public Boolean call(FocusEvent event) {
            return event.getID() == this.id;
        }
    }
}

