/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum PropertyChangeEventSource {


    public static Observable<PropertyChangeEvent> fromPropertyChangeEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<PropertyChangeEvent>(){

            public void call(final Subscriber<? super PropertyChangeEvent> subscriber) {
                final PropertyChangeListener listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                component.addPropertyChangeListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removePropertyChangeListener(listener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }
}

