/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum ContainerEventSource {


    public static Observable<ContainerEvent> fromContainerEventsOf(final Container container) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ContainerEvent>(){

            public void call(final Subscriber<? super ContainerEvent> subscriber) {
                final ContainerListener listener = new ContainerListener(){

                    @Override
                    public void componentRemoved(ContainerEvent event) {
                        subscriber.onNext((Object)event);
                    }

                    @Override
                    public void componentAdded(ContainerEvent event) {
                        subscriber.onNext((Object)event);
                    }
                };
                container.addContainerListener(listener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        container.removeContainerListener(listener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).observeOn((Scheduler)SwingScheduler.getInstance());
    }

    public static enum Predicate implements Func1<ContainerEvent, Boolean>
    {
        COMPONENT_ADDED(300),
        COMPONENT_REMOVED(301);

        private final int id;

        private Predicate(int id) {
            this.id = id;
        }

        public Boolean call(ContainerEvent event) {
            return event.getID() == this.id;
        }
    }
}

