/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Component;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.functions.Func1;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum HierarchyEventSource {


    public static Observable<HierarchyEvent> fromHierarchyEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<HierarchyEvent>(){

            public void call(final Subscriber<? super HierarchyEvent> subscriber) {
                final HierarchyListener hiearchyListener = new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        subscriber.onNext((Object)e);
                    }
                };
                component.addHierarchyListener(hiearchyListener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeHierarchyListener(hiearchyListener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }

    public static Observable<HierarchyEvent> fromHierarchyBoundsEventsOf(final Component component) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<HierarchyEvent>(){

            public void call(final Subscriber<? super HierarchyEvent> subscriber) {
                final HierarchyBoundsListener hiearchyBoundsListener = new HierarchyBoundsListener(){

                    @Override
                    public void ancestorMoved(HierarchyEvent e) {
                        subscriber.onNext((Object)e);
                    }

                    @Override
                    public void ancestorResized(HierarchyEvent e) {
                        subscriber.onNext((Object)e);
                    }
                };
                component.addHierarchyBoundsListener(hiearchyBoundsListener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        component.removeHierarchyBoundsListener(hiearchyBoundsListener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }

    public static enum Predicate implements Func1<HierarchyEvent, Boolean>
    {
        ANCESTOR_RESIZED(1402),
        ANCESTOR_MOVED(1401);

        private final int id;

        private Predicate(int id) {
            this.id = id;
        }

        public Boolean call(HierarchyEvent event) {
            return event.getID() == this.id;
        }
    }
}

