/*
 * Decompiled with CFR 0.152.
 */
package rx.swing.sources;

import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.SwingScheduler;
import rx.subscriptions.Subscriptions;

public enum WindowEventSource {


    public static Observable<WindowEvent> fromWindowEventsOf(final Window window) {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<WindowEvent>(){

            public void call(final Subscriber<? super WindowEvent> subscriber) {
                final WindowListener windowListener = new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowIconified(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowDeiconified(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowActivated(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }

                    @Override
                    public void windowDeactivated(WindowEvent windowEvent) {
                        subscriber.onNext((Object)windowEvent);
                    }
                };
                window.addWindowListener(windowListener);
                subscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        window.removeWindowListener(windowListener);
                    }
                }));
            }
        }).subscribeOn((Scheduler)SwingScheduler.getInstance()).unsubscribeOn((Scheduler)SwingScheduler.getInstance());
    }
}

