/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.os.SystemClock;
import android.util.JsonReader;
import io.reactivex.Flowable;
import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.ImmutableRealmSchema;
import io.realm.ImportFlag;
import io.realm.RealmAsyncTask;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmQuery;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.exceptions.RealmPrimaryKeyConstraintException;
import io.realm.internal.ColumnIndices;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsObject;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmCore;
import io.realm.internal.RealmNotifier;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.Util;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.log.RealmLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Realm
extends BaseRealm {
    private static final String NULL_CONFIG_MSG = "A non-null RealmConfiguration must be provided";
    public static final String DEFAULT_REALM_NAME = "default.realm";
    public static final int ENCRYPTION_KEY_LENGTH = 64;
    private static final Object defaultConfigurationLock = new Object();
    private static RealmConfiguration defaultConfiguration;
    private final RealmSchema schema;

    private Realm(RealmCache cache, OsSharedRealm.VersionID version) {
        super(cache, Realm.createExpectedSchemaInfo(cache.getConfiguration().getSchemaMediator()), version);
        this.schema = new ImmutableRealmSchema(this, new ColumnIndices(this.configuration.getSchemaMediator(), this.sharedRealm.getSchemaInfo()));
        if (this.configuration.isReadOnly()) {
            RealmProxyMediator mediator = this.configuration.getSchemaMediator();
            Set<Class<? extends RealmModel>> classes = mediator.getModelClasses();
            for (Class<? extends RealmModel> clazz : classes) {
                String tableName = Table.getTableNameForClass(mediator.getSimpleClassName(clazz));
                if (this.sharedRealm.hasTable(tableName)) continue;
                this.sharedRealm.close();
                throw new RealmMigrationNeededException(this.configuration.getPath(), String.format(Locale.US, "Cannot open the read only Realm. '%s' is missing.", Table.getClassNameForTable(tableName)));
            }
        }
    }

    private Realm(OsSharedRealm sharedRealm) {
        super(sharedRealm);
        this.schema = new ImmutableRealmSchema(this, new ColumnIndices(this.configuration.getSchemaMediator(), sharedRealm.getSchemaInfo()));
    }

    private static OsSchemaInfo createExpectedSchemaInfo(RealmProxyMediator mediator) {
        return new OsSchemaInfo(mediator.getExpectedObjectSchemaInfoMap().values());
    }

    public Flowable<Realm> asFlowable() {
        return this.configuration.getRxFactory().from(this);
    }

    @Override
    public boolean isEmpty() {
        this.checkIfValid();
        for (RealmObjectSchema clazz : this.schema.getAll()) {
            if (clazz.getClassName().startsWith("__") || clazz.getTable().size() <= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public RealmSchema getSchema() {
        return this.schema;
    }

    public static synchronized void init(Context context) {
        Realm.initializeRealm(context, "");
    }

    private static void initializeRealm(Context context, String userAgent) {
        if (BaseRealm.applicationContext == null) {
            if (context == null) {
                throw new IllegalArgumentException("Non-null context required.");
            }
            Realm.checkFilesDirAvailable(context);
            RealmCore.loadLibrary(context);
            Realm.setDefaultConfiguration(new RealmConfiguration.Builder(context).build());
            ObjectServerFacade.getSyncFacadeIfPossible().initialize(context, userAgent, (configuration, versionID) -> RealmCache.createRealmOrGetFromCache(configuration, Realm.class, versionID), Realm::createInstance);
            BaseRealm.applicationContext = context.getApplicationContext() != null ? context.getApplicationContext() : context;
            OsSharedRealm.initialize(new File(context.getFilesDir(), ".realm.temp"));
        }
    }

    private static void checkFilesDirAvailable(Context context) {
        File filesDir = context.getFilesDir();
        if (filesDir != null) {
            if (filesDir.exists()) {
                return;
            }
            try {
                filesDir.mkdirs();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (filesDir == null || !filesDir.exists()) {
            long[] timeoutsMs = new long[]{1L, 2L, 5L, 10L, 16L};
            long maxTotalWaitMs = 200L;
            long currentTotalWaitMs = 0L;
            int waitIndex = -1;
            while (context.getFilesDir() == null || !context.getFilesDir().exists()) {
                long waitMs = timeoutsMs[Math.min(++waitIndex, timeoutsMs.length - 1)];
                SystemClock.sleep((long)waitMs);
                if ((currentTotalWaitMs += waitMs) <= maxTotalWaitMs) continue;
                break;
            }
        }
        if (context.getFilesDir() == null || !context.getFilesDir().exists()) {
            throw new IllegalStateException("Context.getFilesDir() returns " + context.getFilesDir() + " which is not an existing directory. See https://issuetracker.google.com/issues/36918154");
        }
    }

    public static Realm getDefaultInstance() {
        RealmConfiguration configuration = Realm.getDefaultConfiguration();
        if (configuration == null) {
            if (BaseRealm.applicationContext == null) {
                throw new IllegalStateException("Call `Realm.init(Context)` before calling this method.");
            }
            throw new IllegalStateException("Set default configuration by using `Realm.setDefaultConfiguration(RealmConfiguration)`.");
        }
        return RealmCache.createRealmOrGetFromCache(configuration, Realm.class);
    }

    public static Realm getInstance(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(NULL_CONFIG_MSG);
        }
        return RealmCache.createRealmOrGetFromCache(configuration, Realm.class);
    }

    public static RealmAsyncTask getInstanceAsync(RealmConfiguration configuration, Callback callback) {
        if (configuration == null) {
            throw new IllegalArgumentException(NULL_CONFIG_MSG);
        }
        return RealmCache.createRealmOrGetFromCacheAsync(configuration, callback, Realm.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfiguration(RealmConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(NULL_CONFIG_MSG);
        }
        Object object = defaultConfigurationLock;
        synchronized (object) {
            defaultConfiguration = configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static RealmConfiguration getDefaultConfiguration() {
        Object object = defaultConfigurationLock;
        synchronized (object) {
            return defaultConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDefaultConfiguration() {
        Object object = defaultConfigurationLock;
        synchronized (object) {
            defaultConfiguration = null;
        }
    }

    static Realm createInstance(RealmCache cache, OsSharedRealm.VersionID version) {
        return new Realm(cache, version);
    }

    static Realm createInstance(OsSharedRealm sharedRealm) {
        return new Realm(sharedRealm);
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkIfValid();
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), false);
                continue;
            }
            catch (JSONException e) {
                throw new RealmException("Could not map JSON", e);
            }
        }
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, JSONArray json) {
        if (clazz == null || json == null) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        for (int i = 0; i < json.length(); ++i) {
            try {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
                continue;
            }
            catch (JSONException e) {
                throw new RealmException("Could not map JSON", e);
            }
        }
    }

    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createAllFromJson(clazz, arr);
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, String json) {
        JSONArray arr;
        if (clazz == null || json == null || json.length() == 0) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            arr = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create JSON array from string", e);
        }
        this.createOrUpdateAllFromJson(clazz, arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends RealmModel> void createAllFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        if (clazz == null || inputStream == null) {
            return;
        }
        this.checkIfValid();
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            reader.beginArray();
            while (reader.hasNext()) {
                this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
            }
            reader.endArray();
        }
    }

    public <E extends RealmModel> void createOrUpdateAllFromJson(Class<E> clazz, InputStream in) {
        if (clazz == null || in == null) {
            return;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONArray json = new JSONArray(scanner.next());
            for (int i = 0; i < json.length(); ++i) {
                this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json.getJSONObject(i), true);
            }
        }
    }

    @Nullable
    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkIfValid();
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map JSON", e);
        }
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, JSONObject json) {
        if (clazz == null || json == null) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            return this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, true);
        }
        catch (JSONException e) {
            throw new RealmException("Could not map JSON", e);
        }
    }

    @Nullable
    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        try {
            obj = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createObjectFromJson(clazz, obj);
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, String json) {
        JSONObject obj;
        if (clazz == null || json == null || json.length() == 0) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try {
            obj = new JSONObject(json);
        }
        catch (JSONException e) {
            throw new RealmException("Could not create Json object from string", e);
        }
        return this.createOrUpdateObjectFromJson(clazz, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <E extends RealmModel> E createObjectFromJson(Class<E> clazz, InputStream inputStream) throws IOException {
        E realmObject;
        if (clazz == null || inputStream == null) {
            return null;
        }
        this.checkIfValid();
        if (OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.configuration.getSchemaMediator().getSimpleClassName(clazz)) != null) {
            try (Scanner scanner = null;){
                scanner = this.getFullStringScanner(inputStream);
                JSONObject json = new JSONObject(scanner.next());
                realmObject = this.configuration.getSchemaMediator().createOrUpdateUsingJsonObject(clazz, this, json, false);
            }
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));){
            realmObject = this.configuration.getSchemaMediator().createUsingJsonStream(clazz, this, reader);
        }
        return realmObject;
    }

    public <E extends RealmModel> E createOrUpdateObjectFromJson(Class<E> clazz, InputStream in) {
        if (clazz == null || in == null) {
            return null;
        }
        this.checkIfValid();
        this.checkHasPrimaryKey(clazz);
        try (Scanner scanner = null;){
            scanner = this.getFullStringScanner(in);
            JSONObject json = new JSONObject(scanner.next());
            E e = this.createOrUpdateObjectFromJson(clazz, json);
            return e;
        }
    }

    private Scanner getFullStringScanner(InputStream in) {
        return new Scanner(in, "UTF-8").useDelimiter("\\A");
    }

    public <E extends RealmModel> E createObject(Class<E> clazz) {
        this.checkIfValid();
        RealmProxyMediator mediator = this.configuration.getSchemaMediator();
        if (mediator.isEmbedded(clazz)) {
            throw new IllegalArgumentException("This class is marked embedded. Use `createEmbeddedObject(class, parent, property)` instead:  " + mediator.getSimpleClassName(clazz));
        }
        return this.createObjectInternal(clazz, true, Collections.emptyList());
    }

    <E extends RealmModel> E createObjectInternal(Class<E> clazz, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.schema.getTable(clazz);
        if (OsObjectStore.getPrimaryKeyForObject(this.sharedRealm, this.configuration.getSchemaMediator().getSimpleClassName(clazz)) != null) {
            throw new RealmException(String.format(Locale.US, "'%s' has a primary key, use 'createObject(Class<E>, Object)' instead.", table.getClassName()));
        }
        return this.configuration.getSchemaMediator().newInstance(clazz, this, OsObject.create(table), this.schema.getColumnInfo(clazz), acceptDefaultValue, excludeFields);
    }

    public <E extends RealmModel> E createObject(Class<E> clazz, @Nullable Object primaryKeyValue) {
        this.checkIfValid();
        RealmProxyMediator mediator = this.configuration.getSchemaMediator();
        if (mediator.isEmbedded(clazz)) {
            throw new IllegalArgumentException("This class is marked embedded. Use `createEmbeddedObject(class, parent, property)` instead:  " + mediator.getSimpleClassName(clazz));
        }
        return this.createObjectInternal(clazz, primaryKeyValue, true, Collections.emptyList());
    }

    public <E extends RealmModel> E createEmbeddedObject(Class<E> clazz, RealmModel parentObject, String parentProperty) {
        this.checkIfValid();
        Util.checkNull(parentObject, "parentObject");
        Util.checkEmpty(parentProperty, "parentProperty");
        if (!RealmObject.isManaged(parentObject) || !RealmObject.isValid(parentObject)) {
            throw new IllegalArgumentException("Only valid, managed objects can be a parent to an embedded object.");
        }
        String className = this.schema.getSchemaForClass(clazz).getClassName();
        Class<?> parentClassName = parentObject.getClass();
        RealmObjectSchema parentObjectSchema = this.schema.getSchemaForClass(parentClassName);
        Row embeddedObject = this.getEmbeddedObjectRow(className, (RealmObjectProxy)parentObject, parentProperty, this.schema, parentObjectSchema);
        return this.configuration.getSchemaMediator().newInstance(clazz, this, embeddedObject, this.schema.getColumnInfo(clazz), true, Collections.EMPTY_LIST);
    }

    <E extends RealmModel> E createObjectInternal(Class<E> clazz, @Nullable Object primaryKeyValue, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.schema.getTable(clazz);
        return this.configuration.getSchemaMediator().newInstance(clazz, this, OsObject.createWithPrimaryKey(table, primaryKeyValue), this.schema.getColumnInfo(clazz), acceptDefaultValue, excludeFields);
    }

    public <E extends RealmModel> E copyToRealm(E object, ImportFlag ... flags) {
        this.checkNotNullObject(object);
        return this.copyOrUpdate(object, false, new HashMap<RealmModel, RealmObjectProxy>(), Util.toSet(flags));
    }

    public <E extends RealmModel> E copyToRealmOrUpdate(E object, ImportFlag ... flags) {
        this.checkNotNullObject(object);
        this.checkHasPrimaryKey(object.getClass());
        return this.copyOrUpdate(object, true, new HashMap<RealmModel, RealmObjectProxy>(), Util.toSet(flags));
    }

    public <E extends RealmModel> List<E> copyToRealm(Iterable<E> objects, ImportFlag ... flags) {
        if (objects == null) {
            return new ArrayList();
        }
        ArrayList<RealmModel> realmObjects = objects instanceof Collection ? new ArrayList(((Collection)objects).size()) : new ArrayList<RealmModel>();
        HashMap<RealmModel, RealmObjectProxy> cache = new HashMap<RealmModel, RealmObjectProxy>();
        for (RealmModel object : objects) {
            this.checkNotNullObject(object);
            realmObjects.add(this.copyOrUpdate(object, false, cache, Util.toSet(flags)));
        }
        return realmObjects;
    }

    public void insert(Collection<? extends RealmModel> objects) {
        this.checkIfValidAndInTransaction();
        if (objects == null) {
            throw new IllegalArgumentException("Null objects cannot be inserted into Realm.");
        }
        if (objects.isEmpty()) {
            return;
        }
        this.configuration.getSchemaMediator().insert(this, objects);
    }

    public void insert(RealmModel object) {
        this.checkIfValidAndInTransaction();
        if (object == null) {
            throw new IllegalArgumentException("Null object cannot be inserted into Realm.");
        }
        HashMap<RealmModel, Long> cache = new HashMap<RealmModel, Long>();
        this.configuration.getSchemaMediator().insert(this, object, cache);
    }

    public void insertOrUpdate(Collection<? extends RealmModel> objects) {
        this.checkIfValidAndInTransaction();
        if (objects == null) {
            throw new IllegalArgumentException("Null objects cannot be inserted into Realm.");
        }
        if (objects.isEmpty()) {
            return;
        }
        this.configuration.getSchemaMediator().insertOrUpdate(this, objects);
    }

    public void insertOrUpdate(RealmModel object) {
        this.checkIfValidAndInTransaction();
        if (object == null) {
            throw new IllegalArgumentException("Null object cannot be inserted into Realm.");
        }
        HashMap<RealmModel, Long> cache = new HashMap<RealmModel, Long>();
        this.configuration.getSchemaMediator().insertOrUpdate(this, object, cache);
    }

    public <E extends RealmModel> List<E> copyToRealmOrUpdate(Iterable<E> objects, ImportFlag ... flags) {
        if (objects == null) {
            return new ArrayList(0);
        }
        ArrayList<RealmModel> realmObjects = objects instanceof Collection ? new ArrayList(((Collection)objects).size()) : new ArrayList<RealmModel>();
        HashMap<RealmModel, RealmObjectProxy> cache = new HashMap<RealmModel, RealmObjectProxy>();
        Set<ImportFlag> importFlags = Util.toSet(flags);
        for (RealmModel object : objects) {
            this.checkNotNullObject(object);
            realmObjects.add(this.copyOrUpdate(object, true, cache, importFlags));
        }
        return realmObjects;
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects) {
        return this.copyFromRealm((E)((Object)realmObjects), Integer.MAX_VALUE);
    }

    public <E extends RealmModel> List<E> copyFromRealm(Iterable<E> realmObjects, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        if (realmObjects == null) {
            return new ArrayList(0);
        }
        ArrayList<RealmModel> unmanagedObjects = realmObjects instanceof Collection ? new ArrayList(((Collection)realmObjects).size()) : new ArrayList<RealmModel>();
        HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>> listCache = new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>();
        for (RealmModel object : realmObjects) {
            this.checkValidObjectForDetach(object);
            unmanagedObjects.add(this.createDetachedCopy(object, maxDepth, listCache));
        }
        return unmanagedObjects;
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject) {
        return this.copyFromRealm(realmObject, Integer.MAX_VALUE);
    }

    public <E extends RealmModel> E copyFromRealm(E realmObject, int maxDepth) {
        this.checkMaxDepth(maxDepth);
        this.checkValidObjectForDetach(realmObject);
        return this.createDetachedCopy(realmObject, maxDepth, new HashMap<RealmModel, RealmObjectProxy.CacheData<RealmModel>>());
    }

    public <E extends RealmModel> RealmQuery<E> where(Class<E> clazz) {
        this.checkIfValid();
        return RealmQuery.createQuery(this, clazz);
    }

    public void addChangeListener(RealmChangeListener<Realm> listener) {
        this.addListener(listener);
    }

    public void removeChangeListener(RealmChangeListener<Realm> listener) {
        this.removeListener(listener);
    }

    public void removeAllChangeListeners() {
        this.removeAllListeners();
    }

    public void executeTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        this.checkIfValid();
        this.checkAllowWritesOnUiThread();
        this.beginTransaction();
        try {
            transaction.execute(this);
            this.commitTransaction();
        }
        catch (Throwable e) {
            if (this.isInTransaction()) {
                this.cancelTransaction();
            } else {
                RealmLog.warn("Could not cancel transaction, not currently in a transaction.", new Object[0]);
            }
            throw e;
        }
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction) {
        return this.executeTransactionAsync(transaction, null, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnSuccess onSuccess) {
        if (onSuccess == null) {
            throw new IllegalArgumentException("onSuccess callback can't be null");
        }
        return this.executeTransactionAsync(transaction, onSuccess, null);
    }

    public RealmAsyncTask executeTransactionAsync(Transaction transaction, Transaction.OnError onError) {
        if (onError == null) {
            throw new IllegalArgumentException("onError callback can't be null");
        }
        return this.executeTransactionAsync(transaction, null, onError);
    }

    public RealmAsyncTask executeTransactionAsync(final Transaction transaction, final @Nullable Transaction.OnSuccess onSuccess, final @Nullable Transaction.OnError onError) {
        this.checkIfValid();
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction should not be null");
        }
        if (this.isFrozen()) {
            throw new IllegalStateException("Write transactions on a frozen Realm is not allowed.");
        }
        final boolean canDeliverNotification = this.sharedRealm.capabilities.canDeliverNotification();
        if (onSuccess != null || onError != null) {
            this.sharedRealm.capabilities.checkCanDeliverNotification("Callback cannot be delivered on current thread.");
        }
        final RealmConfiguration realmConfiguration = this.getConfiguration();
        final RealmNotifier realmNotifier = this.sharedRealm.realmNotifier;
        Future<?> pendingTransaction = asyncTaskExecutor.submitTransaction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                OsSharedRealm.VersionID versionID = null;
                Throwable exception = null;
                Realm bgRealm = Realm.getInstance(realmConfiguration);
                bgRealm.beginTransaction();
                try {
                    transaction.execute(bgRealm);
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    bgRealm.commitTransaction();
                    versionID = bgRealm.sharedRealm.getVersionID();
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    try {
                        if (bgRealm.isInTransaction()) {
                            bgRealm.cancelTransaction();
                        }
                    }
                    finally {
                        bgRealm.close();
                    }
                }
                final Throwable backgroundException = exception;
                final OsSharedRealm.VersionID backgroundVersionID = versionID;
                if (canDeliverNotification) {
                    if (backgroundVersionID != null && onSuccess != null) {
                        realmNotifier.post(new Runnable(){

                            @Override
                            public void run() {
                                if (Realm.this.isClosed()) {
                                    onSuccess.onSuccess();
                                    return;
                                }
                                if (Realm.this.sharedRealm.getVersionID().compareTo(backgroundVersionID) < 0) {
                                    Realm.this.sharedRealm.realmNotifier.addTransactionCallback(new Runnable(){

                                        @Override
                                        public void run() {
                                            onSuccess.onSuccess();
                                        }
                                    });
                                } else {
                                    onSuccess.onSuccess();
                                }
                            }
                        });
                    } else if (backgroundException != null) {
                        realmNotifier.post(new Runnable(){

                            @Override
                            public void run() {
                                if (onError == null) {
                                    throw new RealmException("Async transaction failed", backgroundException);
                                }
                                onError.onError(backgroundException);
                            }
                        });
                    }
                } else if (backgroundException != null) {
                    throw new RealmException("Async transaction failed", backgroundException);
                }
            }
        });
        return new RealmAsyncTaskImpl(pendingTransaction, asyncTaskExecutor);
    }

    public void delete(Class<? extends RealmModel> clazz) {
        this.checkIfValid();
        this.schema.getTable(clazz).clear();
    }

    private <E extends RealmModel> E copyOrUpdate(E object, boolean update, Map<RealmModel, RealmObjectProxy> cache, Set<ImportFlag> flags) {
        this.checkIfValid();
        if (!this.isInTransaction()) {
            throw new IllegalStateException("`copyOrUpdate` can only be called inside a write transaction.");
        }
        if (this.configuration.getSchemaMediator().isEmbedded(Util.getOriginalModelClass(object.getClass()))) {
            throw new IllegalArgumentException("Embedded objects cannot be copied into Realm by themselves. They need to be attached to a parent object");
        }
        try {
            return this.configuration.getSchemaMediator().copyOrUpdate(this, object, update, cache, flags);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().startsWith("Attempting to create an object of type")) {
                throw new RealmPrimaryKeyConstraintException(e.getMessage());
            }
            throw e;
        }
    }

    private <E extends RealmModel> E createDetachedCopy(E object, int maxDepth, Map<RealmModel, RealmObjectProxy.CacheData<RealmModel>> cache) {
        this.checkIfValid();
        return this.configuration.getSchemaMediator().createDetachedCopy(object, maxDepth, cache);
    }

    private <E extends RealmModel> void checkNotNullObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Null objects cannot be copied into Realm.");
        }
    }

    private void checkHasPrimaryKey(Class<? extends RealmModel> clazz) {
        if (!this.hasPrimaryKey(clazz)) {
            throw new IllegalArgumentException("A RealmObject with no @PrimaryKey cannot be updated: " + clazz.toString());
        }
    }

    boolean hasPrimaryKey(Class<? extends RealmModel> clazz) {
        return this.configuration.getSchemaMediator().hasPrimaryKey(clazz);
    }

    private void checkMaxDepth(int maxDepth) {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth must be > 0. It was: " + maxDepth);
        }
    }

    private <E extends RealmModel> void checkValidObjectForDetach(E realmObject) {
        if (realmObject == null) {
            throw new IllegalArgumentException("Null objects cannot be copied from Realm.");
        }
        if (!RealmObject.isManaged(realmObject) || !RealmObject.isValid(realmObject)) {
            throw new IllegalArgumentException("Only valid managed objects can be copied from Realm.");
        }
        if (realmObject instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("DynamicRealmObject cannot be copied from Realm.");
        }
    }

    public static void migrateRealm(RealmConfiguration configuration) throws FileNotFoundException {
        Realm.migrateRealm(configuration, null);
    }

    public static void migrateRealm(RealmConfiguration configuration, @Nullable RealmMigration migration) throws FileNotFoundException {
        BaseRealm.migrateRealm(configuration, migration);
    }

    public static boolean deleteRealm(RealmConfiguration configuration) {
        return BaseRealm.deleteRealm(configuration);
    }

    public static boolean compactRealm(RealmConfiguration configuration) {
        return BaseRealm.compactRealm(configuration);
    }

    @Override
    public Realm freeze() {
        return RealmCache.createRealmOrGetFromCache(this.configuration, Realm.class, this.sharedRealm.getVersionID());
    }

    Table getTable(Class<? extends RealmModel> clazz) {
        return this.schema.getTable(clazz);
    }

    @Nullable
    public static Object getDefaultModule() {
        String moduleName = "io.realm.DefaultRealmModule";
        try {
            Class<?> clazz = Class.forName(moduleName);
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (InstantiationException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
        catch (IllegalAccessException e) {
            throw new RealmException("Could not create an instance of " + moduleName, e);
        }
    }

    public static int getGlobalInstanceCount(RealmConfiguration configuration) {
        final AtomicInteger globalCount = new AtomicInteger(0);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            @Override
            public void onResult(int count) {
                globalCount.set(count);
            }
        });
        return globalCount.get();
    }

    public static int getLocalInstanceCount(RealmConfiguration configuration) {
        return RealmCache.getLocalThreadCount(configuration);
    }

    @Nullable
    public static Context getApplicationContext() {
        return applicationContext;
    }

    public static abstract class Callback
    extends BaseRealm.InstanceCallback<Realm> {
        @Override
        public abstract void onSuccess(Realm var1);

        @Override
        public void onError(Throwable exception) {
            super.onError(exception);
        }
    }

    public static interface Transaction {
        public void execute(Realm var1);

        public static interface OnError {
            public void onError(Throwable var1);
        }

        public static interface OnSuccess {
            public void onSuccess();
        }

        public static class Callback {
            public void onSuccess() {
            }

            public void onError(Exception ignore) {
            }
        }
    }
}

