/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.RealmDictionary;
import io.realm.RealmResults;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.OsResults;
import io.realm.internal.Table;
import io.realm.internal.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class SelectorForMap<K, V>
extends TypeSelectorForMap<K, V> {
    protected final Class<K> keyClass;
    protected final Class<V> valueClass;

    SelectorForMap(BaseRealm baseRealm, OsMap osMap, Class<K> keyClass, Class<V> valueClass) {
        super(baseRealm, osMap);
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.produceResults(this.baseRealm, this.osMap.tableAndKeyPtrs(), true, this.keyClass));
    }

    @Override
    public Collection<V> getValues() {
        boolean forPrimitives = !CollectionUtils.isClassForRealmModel(this.valueClass);
        return this.produceResults(this.baseRealm, this.osMap.tableAndValuePtrs(), forPrimitives, this.valueClass);
    }

    @Override
    public RealmDictionary<V> freeze(BaseRealm frozenBaseRealm) {
        return new RealmDictionary<V>(frozenBaseRealm, this.osMap, this.valueClass);
    }

    private <T> RealmResults<T> produceResults(BaseRealm baseRealm, Pair<Table, Long> tableAndValuesPtr, boolean forPrimitives, Class<T> clazz) {
        Long valuesPtr = (Long)tableAndValuesPtr.second;
        OsResults osResults = OsResults.createFromMap(baseRealm.sharedRealm, valuesPtr);
        return new RealmResults<T>(baseRealm, osResults, clazz, forPrimitives);
    }

    @Override
    Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    String getValueClassName() {
        return this.valueClass.getSimpleName();
    }
}

