/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.CompactOnLaunchCallback;
import io.realm.RealmConfiguration;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.OsSharedRealm;
import io.realm.log.RealmLog;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OsRealmConfig
implements NativeObject {
    private static final byte SCHEMA_MODE_VALUE_AUTOMATIC = 0;
    private static final byte SCHEMA_MODE_VALUE_IMMUTABLE = 1;
    private static final byte SCHEMA_MODE_VALUE_READONLY = 2;
    private static final byte SCHEMA_MODE_VALUE_RESET_FILE = 3;
    private static final byte SCHEMA_MODE_VALUE_ADDITIVE_DISCOVERED = 4;
    private static final byte SCHEMA_MODE_VALUE_ADDITIVE_EXPLICIT = 5;
    private static final byte SCHEMA_MODE_VALUE_MANUAL = 6;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_IMMEDIATELY = 0;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_LIVE_INDEFINETELY = 1;
    private static final byte SYNCSESSION_STOP_POLICY_VALUE_AFTER_CHANGES_UPLOADED = 2;
    private static final byte PROXYCONFIG_TYPE_VALUE_HTTP = 0;
    public static final byte CLIENT_RESYNC_MODE_MANUAL = 0;
    public static final byte CLIENT_RESYNC_MODE_DISCARD_LOCAL = 1;
    private static final long nativeFinalizerPtr = OsRealmConfig.nativeGetFinalizerPtr();
    private final RealmConfiguration realmConfiguration;
    private final URI resolvedRealmURI;
    private final long nativePtr;
    private final NativeContext context = new NativeContext();
    private final CompactOnLaunchCallback compactOnLaunchCallback;
    private final OsSharedRealm.MigrationCallback migrationCallback;
    private final OsSharedRealm.InitializationCallback initializationCallback;

    private OsRealmConfig(RealmConfiguration config, String fifoFallbackDir, boolean autoUpdateNotification, @Nullable OsSchemaInfo schemaInfo, @Nullable OsSharedRealm.MigrationCallback migrationCallback, @Nullable OsSharedRealm.InitializationCallback initializationCallback) {
        byte[] key;
        this.realmConfiguration = config;
        this.nativePtr = OsRealmConfig.nativeCreate(config.getPath(), fifoFallbackDir, true, config.getMaxNumberOfActiveVersions());
        NativeContext.dummyContext.addReference(this);
        int j = 0;
        Object[] syncConfigurationOptions = ObjectServerFacade.getSyncFacadeIfPossible().getSyncConfigurationOptions(this.realmConfiguration);
        String syncUserIdentifier = (String)syncConfigurationOptions[j++];
        String syncUserProvider = (String)syncConfigurationOptions[j++];
        String syncRealmUrl = (String)syncConfigurationOptions[j++];
        String syncRealmAuthUrl = (String)syncConfigurationOptions[j++];
        String syncRefreshToken = (String)syncConfigurationOptions[j++];
        String syncAccessToken = (String)syncConfigurationOptions[j++];
        String deviceId = (String)syncConfigurationOptions[j++];
        Byte sessionStopPolicy = (Byte)syncConfigurationOptions[j++];
        String urlPrefix = (String)syncConfigurationOptions[j++];
        String customAuthorizationHeaderName = (String)syncConfigurationOptions[j++];
        Map customHeadersMap = (Map)syncConfigurationOptions[j++];
        Byte clientResyncMode = (Byte)syncConfigurationOptions[j++];
        Object beforeClientResetHandler = syncConfigurationOptions[j++];
        Object afterClientResetHandler = syncConfigurationOptions[j++];
        String encodedPartitionValue = (String)syncConfigurationOptions[j++];
        Object syncService = syncConfigurationOptions[j++];
        Long appPtr = (Long)syncConfigurationOptions[j++];
        String[] customHeaders = new String[customHeadersMap != null ? customHeadersMap.size() * 2 : 0];
        if (customHeadersMap != null) {
            int i = 0;
            for (Map.Entry entry : customHeadersMap.entrySet()) {
                customHeaders[i] = (String)entry.getKey();
                customHeaders[i + 1] = (String)entry.getValue();
                i += 2;
            }
        }
        if ((key = config.getEncryptionKey()) != null) {
            OsRealmConfig.nativeSetEncryptionKey(this.nativePtr, key);
        }
        OsRealmConfig.nativeSetInMemory(this.nativePtr, config.getDurability() == Durability.MEM_ONLY);
        OsRealmConfig.nativeEnableChangeNotification(this.nativePtr, autoUpdateNotification);
        SchemaMode schemaMode = SchemaMode.SCHEMA_MODE_MANUAL;
        if (config.isRecoveryConfiguration()) {
            schemaMode = SchemaMode.SCHEMA_MODE_IMMUTABLE;
        } else if (config.isReadOnly()) {
            schemaMode = SchemaMode.SCHEMA_MODE_READONLY;
        } else if (syncRealmUrl != null) {
            schemaMode = SchemaMode.SCHEMA_MODE_ADDITIVE_DISCOVERED;
        } else if (config.shouldDeleteRealmIfMigrationNeeded()) {
            schemaMode = SchemaMode.SCHEMA_MODE_RESET_FILE;
        }
        long schemaVersion = config.getSchemaVersion();
        long nativeSchemaPtr = schemaInfo == null ? 0L : schemaInfo.getNativePtr();
        this.migrationCallback = migrationCallback;
        this.nativeSetSchemaConfig(this.nativePtr, schemaMode.getNativeValue(), schemaVersion, nativeSchemaPtr, migrationCallback);
        this.compactOnLaunchCallback = config.getCompactOnLaunchCallback();
        if (this.compactOnLaunchCallback != null) {
            OsRealmConfig.nativeSetCompactOnLaunchCallback(this.nativePtr, this.compactOnLaunchCallback);
        }
        this.initializationCallback = initializationCallback;
        if (initializationCallback != null) {
            this.nativeSetInitializationCallback(this.nativePtr, initializationCallback);
        }
        URI resolvedRealmURI = null;
        if (syncRealmUrl != null) {
            String resolvedSyncRealmUrl = this.nativeCreateAndSetSyncConfig(appPtr, this.nativePtr, syncRealmUrl, syncUserIdentifier, syncUserProvider, syncRefreshToken, syncAccessToken, deviceId, sessionStopPolicy, urlPrefix, customAuthorizationHeaderName, customHeaders, clientResyncMode, beforeClientResetHandler, afterClientResetHandler, encodedPartitionValue, syncService);
            try {
                resolvedSyncRealmUrl = syncRealmAuthUrl + urlPrefix.substring(1);
                resolvedRealmURI = new URI(resolvedSyncRealmUrl);
            }
            catch (URISyntaxException e) {
                RealmLog.error(e, "Cannot create a URI from the Realm URL address", new Object[0]);
            }
            ProxySelector proxySelector = ProxySelector.getDefault();
            if (resolvedRealmURI != null && proxySelector != null) {
                Proxy proxy;
                URI websocketUrl = null;
                try {
                    websocketUrl = new URI(resolvedSyncRealmUrl.replaceFirst("ws", "http"));
                }
                catch (URISyntaxException e) {
                    RealmLog.error(e, "Cannot create a URI from the Realm URL address", new Object[0]);
                }
                List<Proxy> proxies = proxySelector.select(websocketUrl);
                if (proxies != null && !proxies.isEmpty() && (proxy = proxies.get(0)).type() != Proxy.Type.DIRECT) {
                    byte proxyType = -1;
                    switch (proxy.type()) {
                        case HTTP: {
                            proxyType = 0;
                            break;
                        }
                    }
                    if (proxy.type() == Proxy.Type.HTTP) {
                        SocketAddress address = proxy.address();
                        if (address instanceof InetSocketAddress) {
                            InetSocketAddress inetAddress = (InetSocketAddress)address;
                            OsRealmConfig.nativeSetSyncConfigProxySettings(this.nativePtr, proxyType, inetAddress.getHostString(), inetAddress.getPort());
                        } else {
                            RealmLog.error("Unsupported proxy socket address type: " + address.getClass().getName(), new Object[0]);
                        }
                    } else {
                        RealmLog.error("SOCKS proxies are not supported.", new Object[0]);
                    }
                }
            }
        }
        this.resolvedRealmURI = resolvedRealmURI;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public RealmConfiguration getRealmConfiguration() {
        return this.realmConfiguration;
    }

    public URI getResolvedRealmURI() {
        return this.resolvedRealmURI;
    }

    NativeContext getContext() {
        return this.context;
    }

    private static native long nativeCreate(String var0, String var1, boolean var2, long var3);

    private static native void nativeSetEncryptionKey(long var0, byte[] var2);

    private static native void nativeSetInMemory(long var0, boolean var2);

    private native void nativeSetSchemaConfig(long var1, byte var3, long var4, long var6, @Nullable OsSharedRealm.MigrationCallback var8);

    private static native void nativeSetCompactOnLaunchCallback(long var0, CompactOnLaunchCallback var2);

    private native void nativeSetInitializationCallback(long var1, OsSharedRealm.InitializationCallback var3);

    private static native void nativeEnableChangeNotification(long var0, boolean var2);

    private native String nativeCreateAndSetSyncConfig(long var1, long var3, String var5, String var6, String var7, String var8, String var9, String var10, byte var11, String var12, String var13, String[] var14, byte var15, Object var16, Object var17, String var18, Object var19);

    private static native void nativeSetSyncConfigSslSettings(long var0, boolean var2, String var3);

    private static native void nativeSetSyncConfigProxySettings(long var0, byte var2, String var3, int var4);

    private static native long nativeGetFinalizerPtr();

    public static class Builder {
        private RealmConfiguration configuration;
        private OsSchemaInfo schemaInfo = null;
        private OsSharedRealm.MigrationCallback migrationCallback = null;
        private OsSharedRealm.InitializationCallback initializationCallback = null;
        private boolean autoUpdateNotification = false;
        private String fifoFallbackDir = "";

        public Builder(RealmConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder schemaInfo(@Nullable OsSchemaInfo schemaInfo) {
            this.schemaInfo = schemaInfo;
            return this;
        }

        public Builder migrationCallback(@Nullable OsSharedRealm.MigrationCallback migrationCallback) {
            this.migrationCallback = migrationCallback;
            return this;
        }

        public Builder initializationCallback(@Nullable OsSharedRealm.InitializationCallback initializationCallback) {
            this.initializationCallback = initializationCallback;
            return this;
        }

        public Builder autoUpdateNotification(boolean autoUpdateNotification) {
            this.autoUpdateNotification = autoUpdateNotification;
            return this;
        }

        public OsRealmConfig build() {
            return new OsRealmConfig(this.configuration, this.fifoFallbackDir, this.autoUpdateNotification, this.schemaInfo, this.migrationCallback, this.initializationCallback);
        }

        public Builder fifoFallbackDir(File dir) {
            this.fifoFallbackDir = dir.getAbsolutePath();
            return this;
        }
    }

    public static enum SyncSessionStopPolicy {
        IMMEDIATELY(0),
        LIVE_INDEFINITELY(1),
        AFTER_CHANGES_UPLOADED(2);

        final byte value;

        private SyncSessionStopPolicy(byte value) {
            this.value = value;
        }

        public byte getNativeValue() {
            return this.value;
        }
    }

    public static enum SchemaMode {
        SCHEMA_MODE_AUTOMATIC(0),
        SCHEMA_MODE_IMMUTABLE(1),
        SCHEMA_MODE_READONLY(2),
        SCHEMA_MODE_RESET_FILE(3),
        SCHEMA_MODE_ADDITIVE_DISCOVERED(4),
        SCHEMA_MODE_MANUAL(6);

        final byte value;

        private SchemaMode(byte value) {
            this.value = value;
        }

        public byte getNativeValue() {
            return this.value;
        }
    }

    public static enum Durability {
        FULL(0),
        MEM_ONLY(1);

        final int value;

        private Durability(int value) {
            this.value = value;
        }
    }
}

