/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class BinaryListOperator
extends ManagedListOperator<byte[]> {
    BinaryListOperator(BaseRealm realm, OsList osList, Class<byte[]> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public byte[] get(int index) {
        return (byte[])this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "byte[]", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addBinary((byte[])value);
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertBinary(index, (byte[])value);
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setBinary(index, (byte[])value);
    }
}

