/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.objectstore;

import io.realm.RealmModel;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.UnmanagedSubscription;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.internal.objectstore.OsSubscription;
import io.realm.internal.objectstore.OsSubscriptionSet;
import io.realm.mongodb.sync.MutableSubscriptionSet;
import io.realm.mongodb.sync.Subscription;

public class OsMutableSubscriptionSet
extends OsSubscriptionSet
implements MutableSubscriptionSet {
    public OsMutableSubscriptionSet(long nativePtr, RealmProxyMediator schema, RealmThreadPoolExecutor listenerExecutor, RealmThreadPoolExecutor updateExecutor) {
        super(nativePtr, schema, listenerExecutor, updateExecutor);
    }

    public Subscription add(Subscription subscription) {
        return this.addSubscription(subscription, true);
    }

    public Subscription addOrUpdate(Subscription subscription) {
        return this.addSubscription(subscription, false);
    }

    private Subscription addSubscription(Subscription subscription, boolean throwOnUpdate) {
        if (subscription instanceof UnmanagedSubscription) {
            UnmanagedSubscription sub = (UnmanagedSubscription)subscription;
            long subscriptionPtr = OsMutableSubscriptionSet.nativeInsertOrAssign(this.getNativePtr(), sub.getName(), sub.getQueryPointer(), throwOnUpdate);
            return new OsSubscription(subscriptionPtr);
        }
        throw new IllegalArgumentException("Only unmanaged subscriptions are allowed as input. This subscription was managed.");
    }

    public boolean remove(Subscription subscription) {
        if (subscription instanceof OsSubscription) {
            return OsMutableSubscriptionSet.nativeRemove(this.getNativePtr(), ((OsSubscription)subscription).getNativePtr());
        }
        throw new IllegalArgumentException("Only managed Subscriptions can be removed.");
    }

    public boolean remove(String name) {
        return OsMutableSubscriptionSet.nativeRemoveNamed(this.getNativePtr(), name);
    }

    public boolean removeAll(String type) {
        return OsMutableSubscriptionSet.nativeRemoveAllForType(this.getNativePtr(), type);
    }

    public <T extends RealmModel> boolean removeAll(Class<T> clazz) {
        return OsMutableSubscriptionSet.nativeRemoveAllForType(this.getNativePtr(), this.schema.getSimpleClassName(clazz));
    }

    public boolean removeAll() {
        return OsMutableSubscriptionSet.nativeRemoveAll(this.getNativePtr());
    }

    public long commit() {
        return OsMutableSubscriptionSet.nativeCommit(this.getNativePtr());
    }

    private static native long nativeInsertOrAssign(long var0, String var2, long var3, boolean var5);

    private static native boolean nativeRemoveNamed(long var0, String var2);

    private static native boolean nativeRemove(long var0, long var2);

    private static native long nativeCommit(long var0);

    private static native boolean nativeRemoveAll(long var0);

    private static native boolean nativeRemoveAllForType(long var0, String var2);
}

