/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.async;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.realm.internal.async.BgPriorityRunnable;
import java.io.File;
import java.io.FileFilter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

public class RealmThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final String SYS_CPU_DIR = "/sys/devices/system/cpu/";
    private static final int CORE_POOL_SIZE = RealmThreadPoolExecutor.calculateCorePoolSize();
    private static final int QUEUE_SIZE = 100;
    private boolean isPaused;
    private ReentrantLock pauseLock = new ReentrantLock();
    private Condition unpaused = this.pauseLock.newCondition();

    public static RealmThreadPoolExecutor newDefaultExecutor() {
        return new RealmThreadPoolExecutor(CORE_POOL_SIZE, CORE_POOL_SIZE);
    }

    public static RealmThreadPoolExecutor newSingleThreadExecutor() {
        return new RealmThreadPoolExecutor(1, 1);
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static int calculateCorePoolSize() {
        int cpus = RealmThreadPoolExecutor.countFilesInDir(SYS_CPU_DIR, "cpu[0-9]+");
        if (cpus <= 0) {
            cpus = Runtime.getRuntime().availableProcessors();
        }
        return cpus <= 0 ? 1 : cpus * 2 + 1;
    }

    private static int countFilesInDir(String dirPath, String pattern) {
        final Pattern filePattern = Pattern.compile(pattern);
        try {
            File[] files = new File(dirPath).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return filePattern.matcher(file.getName()).matches();
                }
            });
            return files == null ? 0 : files.length;
        }
        catch (SecurityException securityException) {
            return 0;
        }
    }

    private RealmThreadPoolExecutor(int corePoolSize, int maxPoolSize) {
        super(corePoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(100));
    }

    public Future<?> submitTransaction(Runnable task) {
        Future<?> future = super.submit(new BgPriorityRunnable(task));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.pauseLock.lock();
        try {
            while (this.isPaused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void pause() {
        this.pauseLock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public void resume() {
        this.pauseLock.lock();
        try {
            this.isPaused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }
}

