/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionImpl;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.internal.OsResults;
import io.realm.internal.UncheckedRow;
import java.util.Locale;

public class OrderedRealmCollectionSnapshot<E>
extends OrderedRealmCollectionImpl<E> {
    private int size = -1;

    OrderedRealmCollectionSnapshot(BaseRealm realm, OsResults osResults, Class<E> clazz) {
        super(realm, osResults.createSnapshot(), clazz);
    }

    OrderedRealmCollectionSnapshot(BaseRealm realm, OsResults osResults, String className) {
        super(realm, osResults.createSnapshot(), className);
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = super.size();
        }
        return this.size;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        throw this.getUnsupportedException("sort");
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        throw this.getUnsupportedException("sort");
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        throw this.getUnsupportedException("sort");
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        throw this.getUnsupportedException("sort");
    }

    @Override
    @Deprecated
    public RealmQuery<E> where() {
        throw this.getUnsupportedException("where");
    }

    private UnsupportedOperationException getUnsupportedException(String methodName) {
        return new UnsupportedOperationException(String.format(Locale.US, "'%s()' is not supported by OrderedRealmCollectionSnapshot. Call '%s()' on the original 'RealmCollection' instead.", methodName, methodName));
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public OrderedRealmCollectionSnapshot<E> createSnapshot() {
        this.baseRealm.checkIfValid();
        return this;
    }

    @Override
    public OrderedRealmCollection<E> freeze() {
        throw this.getUnsupportedException("freeze");
    }

    @Override
    public void deleteFromRealm(int location) {
        this.baseRealm.checkIfValidAndInTransaction();
        UncheckedRow row = this.osResults.getUncheckedRow(location);
        if (row.isValid()) {
            this.osResults.delete(location);
        }
    }

    @Override
    public boolean deleteFirstFromRealm() {
        this.baseRealm.checkIfValidAndInTransaction();
        UncheckedRow row = this.osResults.firstUncheckedRow();
        return row != null && row.isValid() && this.osResults.deleteFirst();
    }

    @Override
    public boolean deleteLastFromRealm() {
        this.baseRealm.checkIfValidAndInTransaction();
        UncheckedRow row = this.osResults.lastUncheckedRow();
        return row != null && row.isValid() && this.osResults.deleteLast();
    }

    @Override
    public boolean deleteAllFromRealm() {
        return super.deleteAllFromRealm();
    }

    @Override
    public boolean isFrozen() {
        return false;
    }
}

