/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.ManagedMapManager;
import io.realm.MapChangeListener;
import io.realm.RealmChangeListener;
import io.realm.internal.Freezable;
import io.realm.internal.ManageableObject;
import io.realm.internal.OsMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class RealmMap<K, V>
implements Map<K, V>,
ManageableObject,
Freezable<RealmMap<K, V>> {
    protected final MapStrategy<K, V> mapStrategy;

    protected RealmMap() {
        this.mapStrategy = new UnmanagedMapStrategy();
    }

    RealmMap(Map<K, V> map) {
        this();
        this.mapStrategy.putAll(map);
    }

    RealmMap(MapStrategy<K, V> mapStrategy) {
        this.mapStrategy = mapStrategy;
    }

    @Override
    public boolean isManaged() {
        return this.mapStrategy.isManaged();
    }

    @Override
    public boolean isValid() {
        return this.mapStrategy.isValid();
    }

    @Override
    public boolean isFrozen() {
        return this.mapStrategy.isFrozen();
    }

    @Override
    public int size() {
        return this.mapStrategy.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapStrategy.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.mapStrategy.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.mapStrategy.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mapStrategy.get(key);
    }

    @Override
    public V put(K key, @Nullable V value) {
        return this.mapStrategy.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.mapStrategy.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.mapStrategy.putAll(m);
    }

    @Override
    public void clear() {
        this.mapStrategy.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mapStrategy.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mapStrategy.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mapStrategy.entrySet();
    }

    @Override
    public RealmMap<K, V> freeze() {
        return (RealmMap)this.mapStrategy.freeze();
    }

    public void addChangeListener(MapChangeListener<K, V> listener) {
        this.mapStrategy.addChangeListener(this, listener);
    }

    public void addChangeListener(RealmChangeListener<RealmMap<K, V>> listener) {
        this.mapStrategy.addChangeListener(this, listener);
    }

    public void removeChangeListener(MapChangeListener<K, V> listener) {
        this.mapStrategy.removeChangeListener(this, listener);
    }

    public void removeChangeListener(RealmChangeListener<RealmMap<K, V>> listener) {
        this.mapStrategy.removeChangeListener(this, listener);
    }

    public void removeAllChangeListeners() {
        this.mapStrategy.removeAllChangeListeners();
    }

    boolean hasListeners() {
        return this.mapStrategy.hasListeners();
    }

    OsMap getOsMap() {
        return this.mapStrategy.getOsMap();
    }

    String getValueClassName() {
        return this.mapStrategy.getValueClassName();
    }

    Class<V> getValueClass() {
        return this.mapStrategy.getValueClass();
    }

    private static class UnmanagedMapStrategy<K, V>
    extends MapStrategy<K, V> {
        private final Map<K, V> unmanagedMap = new HashMap();

        private UnmanagedMapStrategy() {
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        @Override
        public int size() {
            return this.unmanagedMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.unmanagedMap.isEmpty();
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return this.unmanagedMap.containsKey(key);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return this.unmanagedMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.unmanagedMap.get(key);
        }

        @Override
        public V remove(Object key) {
            return this.unmanagedMap.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.unmanagedMap.putAll(m);
        }

        @Override
        public void clear() {
            this.unmanagedMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.unmanagedMap.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.unmanagedMap.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.unmanagedMap.entrySet();
        }

        @Override
        public RealmMap<K, V> freeze() {
            throw new UnsupportedOperationException("Unmanaged RealmMaps cannot be frozen.");
        }

        @Override
        protected V putInternal(K key, @Nullable V value) {
            return this.unmanagedMap.put(key, value);
        }

        @Override
        protected void addChangeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener) {
            throw new UnsupportedOperationException("Unmanaged RealmMaps do not support change listeners.");
        }

        @Override
        protected void addChangeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener) {
            throw new UnsupportedOperationException("Unmanaged RealmMaps do not support change listeners.");
        }

        @Override
        protected void removeChangeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener) {
            throw new UnsupportedOperationException("Cannot remove change listener because unmanaged RealmMaps do not support change listeners.");
        }

        @Override
        protected void removeChangeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener) {
            throw new UnsupportedOperationException("Cannot remove change listener because unmanaged RealmMaps do not support change listeners.");
        }

        @Override
        protected void removeAllChangeListeners() {
            throw new UnsupportedOperationException("Cannot remove change listener because unmanaged RealmMaps do not support change listeners.");
        }

        @Override
        protected boolean hasListeners() {
            return false;
        }

        @Override
        OsMap getOsMap() {
            throw new UnsupportedOperationException("Unmanaged maps aren't represented in native code.");
        }

        @Override
        String getValueClassName() {
            throw new UnsupportedOperationException("Unmanaged maps do not support retrieving the value class name.");
        }

        @Override
        Class<V> getValueClass() {
            throw new UnsupportedOperationException("Unmanaged maps do not support retrieving the value class.");
        }
    }

    static class ManagedMapStrategy<K, V>
    extends MapStrategy<K, V> {
        private final ManagedMapManager<K, V> managedMapManager;

        ManagedMapStrategy(ManagedMapManager<K, V> managedMapManager) {
            this.managedMapManager = managedMapManager;
        }

        @Override
        public boolean isManaged() {
            return this.managedMapManager.isManaged();
        }

        @Override
        public boolean isValid() {
            return this.managedMapManager.isValid();
        }

        @Override
        public boolean isFrozen() {
            return this.managedMapManager.isFrozen();
        }

        @Override
        public int size() {
            return this.managedMapManager.size();
        }

        @Override
        public boolean isEmpty() {
            return this.managedMapManager.isEmpty();
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return this.managedMapManager.containsKey(key);
        }

        @Override
        public boolean containsValue(@Nullable Object value) {
            return this.managedMapManager.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.managedMapManager.get(key);
        }

        @Override
        public V remove(Object key) {
            return this.managedMapManager.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.managedMapManager.putAll(m);
        }

        @Override
        public void clear() {
            this.managedMapManager.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.managedMapManager.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.managedMapManager.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.managedMapManager.entrySet();
        }

        @Override
        public RealmMap<K, V> freeze() {
            return this.managedMapManager.freeze();
        }

        @Override
        protected V putInternal(K key, V value) {
            return this.managedMapManager.put(key, value);
        }

        @Override
        protected void addChangeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener) {
            this.managedMapManager.addChangeListener(realmMap, listener);
        }

        @Override
        protected void addChangeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener) {
            this.managedMapManager.addChangeListener(realmMap, listener);
        }

        @Override
        protected void removeChangeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener) {
            this.managedMapManager.removeListener(realmMap, listener);
        }

        @Override
        protected void removeChangeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener) {
            this.managedMapManager.removeListener(realmMap, listener);
        }

        @Override
        protected void removeAllChangeListeners() {
            this.managedMapManager.removeAllChangeListeners();
        }

        @Override
        protected boolean hasListeners() {
            return this.managedMapManager.hasListeners();
        }

        @Override
        OsMap getOsMap() {
            return this.managedMapManager.getOsMap();
        }

        @Override
        String getValueClassName() {
            return this.managedMapManager.getClassName();
        }

        @Override
        Class<V> getValueClass() {
            return this.managedMapManager.getValueClass();
        }
    }

    static abstract class MapStrategy<K, V>
    implements Map<K, V>,
    ManageableObject,
    Freezable<RealmMap<K, V>> {
        MapStrategy() {
        }

        abstract V putInternal(K var1, @Nullable V var2);

        abstract void addChangeListener(RealmMap<K, V> var1, MapChangeListener<K, V> var2);

        abstract void addChangeListener(RealmMap<K, V> var1, RealmChangeListener<RealmMap<K, V>> var2);

        abstract void removeChangeListener(RealmMap<K, V> var1, MapChangeListener<K, V> var2);

        abstract void removeChangeListener(RealmMap<K, V> var1, RealmChangeListener<RealmMap<K, V>> var2);

        abstract void removeAllChangeListeners();

        abstract boolean hasListeners();

        abstract OsMap getOsMap();

        abstract String getValueClassName();

        abstract Class<V> getValueClass();

        @Override
        public V put(K key, V value) {
            this.checkValidKey(key);
            return this.putInternal(key, value);
        }

        protected void checkValidKey(K key) {
            String stringKey;
            if (key == null) {
                throw new NullPointerException("Null keys are not allowed.");
            }
            if (key.getClass() == String.class && ((stringKey = (String)key).contains(".") || stringKey.contains("$"))) {
                throw new IllegalArgumentException("Keys containing dots ('.') or dollar signs ('$') are not allowed.");
            }
        }
    }
}

