/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedListOperator;
import io.realm.internal.OsList;
import java.util.Locale;
import javax.annotation.Nullable;

final class DoubleListOperator
extends ManagedListOperator<Double> {
    DoubleListOperator(BaseRealm realm, OsList osList, Class<Double> clazz) {
        super(realm, osList, clazz);
    }

    @Override
    public boolean forRealmModel() {
        return false;
    }

    @Override
    @Nullable
    public Double get(int index) {
        return (Double)this.osList.getValue(index);
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.Number", value.getClass().getName()));
        }
    }

    @Override
    public void appendValue(Object value) {
        this.osList.addDouble(((Number)value).doubleValue());
    }

    @Override
    public void insertValue(int index, Object value) {
        this.osList.insertDouble(index, ((Number)value).doubleValue());
    }

    @Override
    protected void setValue(int index, Object value) {
        this.osList.setDouble(index, ((Number)value).doubleValue());
    }
}

