/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.realm.BaseRealm;
import io.realm.BinaryListOperator;
import io.realm.BooleanListOperator;
import io.realm.CollectionUtils;
import io.realm.DateListOperator;
import io.realm.Decimal128ListOperator;
import io.realm.DoubleListOperator;
import io.realm.DynamicRealm;
import io.realm.FloatListOperator;
import io.realm.LongListOperator;
import io.realm.ManagedListOperator;
import io.realm.ObjectIdListOperator;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.OrderedRealmCollectionSnapshot;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmAnyListOperator;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmModelListOperator;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.Sort;
import io.realm.StringListOperator;
import io.realm.UUIDListOperator;
import io.realm.internal.InvalidRow;
import io.realm.internal.OsList;
import io.realm.internal.OsResults;
import io.realm.internal.RealmObjectProxy;
import io.realm.rx.CollectionChange;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class RealmList<E>
extends AbstractList<E>
implements OrderedRealmCollection<E> {
    private static final String ONLY_IN_MANAGED_MODE_MESSAGE = "This method is only available in managed mode.";
    static final String ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE = "This feature is available only when the element type is implementing RealmModel.";
    private static final String REMOVE_OUTSIDE_TRANSACTION_ERROR = "Objects can only be removed from inside a write transaction.";
    @Nullable
    protected Class<E> clazz;
    @Nullable
    protected String className;
    private final ManagedListOperator<E> osListOperator;
    public final BaseRealm baseRealm;
    private List<E> unmanagedList;

    public RealmList() {
        this.baseRealm = null;
        this.osListOperator = null;
        this.unmanagedList = new ArrayList();
    }

    public RealmList(E ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The objects argument cannot be null");
        }
        this.baseRealm = null;
        this.osListOperator = null;
        this.unmanagedList = new ArrayList(objects.length);
        Collections.addAll(this.unmanagedList, objects);
    }

    RealmList(Class<E> clazz, OsList osList, BaseRealm baseRealm) {
        this.clazz = clazz;
        this.osListOperator = this.getOperator(baseRealm, osList, clazz, null);
        this.baseRealm = baseRealm;
    }

    RealmList(String className, OsList osList, BaseRealm baseRealm) {
        this.baseRealm = baseRealm;
        this.className = className;
        this.osListOperator = this.getOperator(baseRealm, osList, null, className);
    }

    OsList getOsList() {
        return this.osListOperator.getOsList();
    }

    long createAndAddEmbeddedObject() {
        return this.osListOperator.getOsList().createAndAddEmbeddedObject();
    }

    @Override
    public boolean isValid() {
        if (this.baseRealm == null) {
            return true;
        }
        if (this.baseRealm.isClosed()) {
            return false;
        }
        return this.isAttached();
    }

    @Override
    public RealmList<E> freeze() {
        if (this.isManaged()) {
            if (!this.isValid()) {
                throw new IllegalStateException("Only valid, managed RealmLists can be frozen.");
            }
            BaseRealm frozenRealm = this.baseRealm.freeze();
            OsList frozenList = this.getOsList().freeze(frozenRealm.sharedRealm);
            if (this.className != null) {
                return new RealmList<E>(this.className, frozenList, frozenRealm);
            }
            return new RealmList<E>(this.clazz, frozenList, frozenRealm);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean isFrozen() {
        return this.baseRealm != null && this.baseRealm.isFrozen();
    }

    @Override
    public boolean isManaged() {
        return this.baseRealm != null;
    }

    private boolean isAttached() {
        return this.osListOperator != null && this.osListOperator.isValid();
    }

    @Override
    public void add(int location, @Nullable E element) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.insert(location, element);
        } else {
            this.unmanagedList.add(location, element);
        }
        ++this.modCount;
    }

    @Override
    public boolean add(@Nullable E object) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.append(object);
        } else {
            this.unmanagedList.add(object);
        }
        ++this.modCount;
        return true;
    }

    @Override
    public E set(int location, @Nullable E object) {
        E oldObject;
        if (this.isManaged()) {
            this.checkValidRealm();
            oldObject = this.osListOperator.set(location, object);
        } else {
            oldObject = this.unmanagedList.set(location, object);
        }
        return oldObject;
    }

    public void move(int oldPos, int newPos) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.move(oldPos, newPos);
        } else {
            int listSize = this.unmanagedList.size();
            if (oldPos < 0 || listSize <= oldPos) {
                throw new IndexOutOfBoundsException("Invalid index " + oldPos + ", size is " + listSize);
            }
            if (newPos < 0 || listSize <= newPos) {
                throw new IndexOutOfBoundsException("Invalid index " + newPos + ", size is " + listSize);
            }
            E object = this.unmanagedList.remove(oldPos);
            this.unmanagedList.add(newPos, object);
        }
    }

    @Override
    public void clear() {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.removeAll();
        } else {
            this.unmanagedList.clear();
        }
        ++this.modCount;
    }

    @Override
    public E remove(int location) {
        E removedItem;
        if (this.isManaged()) {
            this.checkValidRealm();
            removedItem = this.get(location);
            this.osListOperator.remove(location);
        } else {
            removedItem = this.unmanagedList.remove(location);
        }
        ++this.modCount;
        return removedItem;
    }

    @Override
    public boolean remove(@Nullable Object object) {
        if (this.isManaged() && !this.baseRealm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (this.isManaged() && !this.baseRealm.isInTransaction()) {
            throw new IllegalStateException(REMOVE_OUTSIDE_TRANSACTION_ERROR);
        }
        return super.removeAll(collection);
    }

    @Override
    public boolean deleteFirstFromRealm() {
        if (this.isManaged()) {
            if (!this.osListOperator.isEmpty()) {
                this.deleteFromRealm(0);
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean deleteLastFromRealm() {
        if (this.isManaged()) {
            if (!this.osListOperator.isEmpty()) {
                this.osListOperator.deleteLast();
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    @Nullable
    public E get(int location) {
        if (this.isManaged()) {
            this.checkValidRealm();
            return this.osListOperator.get(location);
        }
        return this.unmanagedList.get(location);
    }

    @Override
    @Nullable
    public E first() {
        return this.firstImpl(true, null);
    }

    @Override
    @Nullable
    public E first(@Nullable E defaultValue) {
        return this.firstImpl(false, defaultValue);
    }

    @Nullable
    private E firstImpl(boolean shouldThrow, @Nullable E defaultValue) {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                return this.get(0);
            }
        } else if (this.unmanagedList != null && !this.unmanagedList.isEmpty()) {
            return this.unmanagedList.get(0);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("The list is empty.");
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public E last() {
        return this.lastImpl(true, null);
    }

    @Override
    @Nullable
    public E last(@Nullable E defaultValue) {
        return this.lastImpl(false, defaultValue);
    }

    @Nullable
    private E lastImpl(boolean shouldThrow, @Nullable E defaultValue) {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                return this.get(this.osListOperator.size() - 1);
            }
        } else if (this.unmanagedList != null && !this.unmanagedList.isEmpty()) {
            return this.unmanagedList.get(this.unmanagedList.size() - 1);
        }
        if (shouldThrow) {
            throw new IndexOutOfBoundsException("The list is empty.");
        }
        return defaultValue;
    }

    @Override
    public RealmResults<E> sort(String fieldName) {
        return this.sort(fieldName, Sort.ASCENDING);
    }

    @Override
    public RealmResults<E> sort(String fieldName, Sort sortOrder) {
        if (this.isManaged()) {
            return this.where().sort(fieldName, sortOrder).findAll();
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public RealmResults<E> sort(String fieldName1, Sort sortOrder1, String fieldName2, Sort sortOrder2) {
        return this.sort(new String[]{fieldName1, fieldName2}, new Sort[]{sortOrder1, sortOrder2});
    }

    @Override
    public RealmResults<E> sort(String[] fieldNames, Sort[] sortOrders) {
        if (this.isManaged()) {
            return this.where().sort(fieldNames, sortOrders).findAll();
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public void deleteFromRealm(int location) {
        if (this.isManaged()) {
            this.checkValidRealm();
            this.osListOperator.delete(location);
            ++this.modCount;
        } else {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }
    }

    @Override
    public int size() {
        if (this.isManaged()) {
            this.checkValidRealm();
            return this.osListOperator.size();
        }
        return this.unmanagedList.size();
    }

    @Override
    public RealmQuery<E> where() {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.forRealmModel()) {
                throw new UnsupportedOperationException(ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE);
            }
            return RealmQuery.createQueryFromList(this);
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    @Nullable
    public Number min(String fieldName) {
        return this.where().min(fieldName);
    }

    @Override
    @Nullable
    public Number max(String fieldName) {
        return this.where().max(fieldName);
    }

    @Override
    public Number sum(String fieldName) {
        return this.where().sum(fieldName);
    }

    @Override
    public double average(String fieldName) {
        return this.where().average(fieldName);
    }

    @Override
    @Nullable
    public Date maxDate(String fieldName) {
        return this.where().maximumDate(fieldName);
    }

    @Override
    @Nullable
    public Date minDate(String fieldName) {
        return this.where().minimumDate(fieldName);
    }

    @Override
    public boolean deleteAllFromRealm() {
        if (this.isManaged()) {
            this.checkValidRealm();
            if (!this.osListOperator.isEmpty()) {
                this.osListOperator.deleteAll();
                ++this.modCount;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean load() {
        return true;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.isManaged()) {
            RealmObjectProxy proxy;
            this.baseRealm.checkIfValid();
            if (object instanceof RealmObjectProxy && (proxy = (RealmObjectProxy)object).realmGet$proxyState().getRow$realm() == InvalidRow.INSTANCE) {
                return false;
            }
            return super.contains(object);
        }
        return this.unmanagedList.contains(object);
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        if (this.isManaged()) {
            return new RealmItr();
        }
        return super.iterator();
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @Nonnull
    public ListIterator<E> listIterator(int location) {
        if (this.isManaged()) {
            return new RealmListItr(location);
        }
        return super.listIterator(location);
    }

    private void checkValidRealm() {
        this.baseRealm.checkIfValid();
    }

    @Override
    public OrderedRealmCollectionSnapshot<E> createSnapshot() {
        if (!this.isManaged()) {
            throw new UnsupportedOperationException(ONLY_IN_MANAGED_MODE_MESSAGE);
        }
        this.checkValidRealm();
        if (!this.osListOperator.forRealmModel()) {
            throw new UnsupportedOperationException(ALLOWED_ONLY_FOR_REALM_MODEL_ELEMENT_MESSAGE);
        }
        if (this.className != null) {
            return new OrderedRealmCollectionSnapshot(this.baseRealm, OsResults.createFromQuery(this.baseRealm.sharedRealm, this.osListOperator.getOsList().getQuery()), this.className);
        }
        return new OrderedRealmCollectionSnapshot<E>(this.baseRealm, OsResults.createFromQuery(this.baseRealm.sharedRealm, this.osListOperator.getOsList().getQuery()), this.clazz);
    }

    public Realm getRealm() {
        if (this.baseRealm == null) {
            return null;
        }
        this.baseRealm.checkIfValid();
        if (!(this.baseRealm instanceof Realm)) {
            throw new IllegalStateException("This method is only available for typed Realms");
        }
        return (Realm)this.baseRealm;
    }

    @Override
    public String toString() {
        String separator = ",";
        StringBuilder sb = new StringBuilder();
        if (!this.isManaged()) {
            sb.append("RealmList<?>@[");
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                E value = this.get(i);
                if (value instanceof RealmModel) {
                    sb.append(System.identityHashCode(value));
                } else if (value instanceof byte[]) {
                    sb.append("byte[").append(((byte[])value).length).append("]");
                } else {
                    sb.append(value);
                }
                sb.append(",");
            }
            if (0 < this.size()) {
                sb.setLength(sb.length() - ",".length());
            }
            sb.append("]");
        } else {
            sb.append("RealmList<");
            if (this.className != null) {
                sb.append(this.className);
            } else if (RealmList.isClassForRealmModel(this.clazz)) {
                sb.append(this.baseRealm.getSchema().getSchemaForClass(this.clazz).getClassName());
            } else if (this.clazz == byte[].class) {
                sb.append(this.clazz.getSimpleName());
            } else {
                sb.append(this.clazz.getName());
            }
            sb.append(">@[");
            if (!this.isAttached()) {
                sb.append("invalid");
            } else if (RealmList.isClassForRealmModel(this.clazz)) {
                for (int i = 0; i < this.size(); ++i) {
                    sb.append(((RealmObjectProxy)this.get(i)).realmGet$proxyState().getRow$realm().getObjectKey());
                    sb.append(",");
                }
                if (0 < this.size()) {
                    sb.setLength(sb.length() - ",".length());
                }
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    E value = this.get(i);
                    if (value instanceof byte[]) {
                        sb.append("byte[").append(((byte[])value).length).append("]");
                    } else {
                        sb.append(value);
                    }
                    sb.append(",");
                }
                if (0 < this.size()) {
                    sb.setLength(sb.length() - ",".length());
                }
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public Flowable<RealmList<E>> asFlowable() {
        if (this.baseRealm instanceof Realm) {
            return this.baseRealm.configuration.getRxFactory().from((Realm)this.baseRealm, this);
        }
        if (this.baseRealm instanceof DynamicRealm) {
            Flowable results = this.baseRealm.configuration.getRxFactory().from((DynamicRealm)this.baseRealm, this);
            return results;
        }
        throw new UnsupportedOperationException(this.baseRealm.getClass() + " does not support RxJava2.");
    }

    public Observable<CollectionChange<RealmList<E>>> asChangesetObservable() {
        if (this.baseRealm instanceof Realm) {
            return this.baseRealm.configuration.getRxFactory().changesetsFrom((Realm)this.baseRealm, this);
        }
        if (this.baseRealm instanceof DynamicRealm) {
            DynamicRealm dynamicRealm = (DynamicRealm)this.baseRealm;
            RealmList dynamicResults = this;
            return this.baseRealm.configuration.getRxFactory().changesetsFrom(dynamicRealm, dynamicResults);
        }
        throw new UnsupportedOperationException(this.baseRealm.getClass() + " does not support RxJava2.");
    }

    public void addChangeListener(OrderedRealmCollectionChangeListener<RealmList<E>> listener) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener, true);
        this.osListOperator.getOsList().addListener(this, listener);
    }

    public void removeChangeListener(OrderedRealmCollectionChangeListener<RealmList<E>> listener) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener, true);
        this.osListOperator.getOsList().removeListener(this, listener);
    }

    public void addChangeListener(RealmChangeListener<RealmList<E>> listener) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener, true);
        this.osListOperator.getOsList().addListener(this, listener);
    }

    public void removeChangeListener(RealmChangeListener<RealmList<E>> listener) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener, true);
        this.osListOperator.getOsList().removeListener(this, listener);
    }

    public void removeAllChangeListeners() {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, null, false);
        this.osListOperator.getOsList().removeAllListeners();
    }

    private static boolean isClassForRealmModel(Class<?> clazz) {
        return RealmModel.class.isAssignableFrom(clazz);
    }

    private ManagedListOperator<E> getOperator(BaseRealm realm, OsList osList, @Nullable Class<E> clazz, @Nullable String className) {
        if (clazz == null || RealmList.isClassForRealmModel(clazz)) {
            return new RealmModelListOperator<E>(realm, osList, clazz, className);
        }
        if (clazz == String.class) {
            return new StringListOperator(realm, osList, clazz);
        }
        if (clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class) {
            return new LongListOperator<String>(realm, osList, clazz);
        }
        if (clazz == Boolean.class) {
            return new BooleanListOperator(realm, osList, (Class<Boolean>)clazz);
        }
        if (clazz == byte[].class) {
            return new BinaryListOperator(realm, osList, (Class<byte[]>)clazz);
        }
        if (clazz == Double.class) {
            return new DoubleListOperator(realm, osList, (Class<Double>)clazz);
        }
        if (clazz == Float.class) {
            return new FloatListOperator(realm, osList, (Class<Float>)clazz);
        }
        if (clazz == Date.class) {
            return new DateListOperator(realm, osList, (Class<Date>)clazz);
        }
        if (clazz == Decimal128.class) {
            return new Decimal128ListOperator(realm, osList, (Class<Decimal128>)clazz);
        }
        if (clazz == ObjectId.class) {
            return new ObjectIdListOperator(realm, osList, (Class<ObjectId>)clazz);
        }
        if (clazz == UUID.class) {
            return new UUIDListOperator(realm, osList, (Class<UUID>)clazz);
        }
        if (clazz == RealmAny.class) {
            return new RealmAnyListOperator(realm, osList, (Class<RealmAny>)clazz);
        }
        throw new IllegalArgumentException("Unexpected value class: " + clazz.getName());
    }

    static /* synthetic */ int access$100(RealmList x0) {
        return x0.modCount;
    }

    private class RealmListItr
    extends RealmItr
    implements ListIterator<E> {
        RealmListItr(int index) {
            if (index < 0 || index > RealmList.this.size()) {
                throw new IndexOutOfBoundsException("Starting location must be a valid index: [0, " + (RealmList.this.size() - 1) + "]. Index was " + index);
            }
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        @Nullable
        public E previous() {
            this.checkConcurrentModification();
            int i = this.cursor - 1;
            try {
                Object previous = RealmList.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index less than zero. This was " + i + ". Remember to check hasPrevious() before using previous().");
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(@Nullable E e) {
            RealmList.this.baseRealm.checkIfValid();
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.set(this.lastRet, e);
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(@Nullable E e) {
            RealmList.this.baseRealm.checkIfValid();
            this.checkConcurrentModification();
            try {
                int i = this.cursor;
                RealmList.this.add(i, e);
                this.lastRet = -1;
                this.cursor = i + 1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class RealmItr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = RealmList.access$100(RealmList.this);

        private RealmItr() {
        }

        @Override
        public boolean hasNext() {
            RealmList.this.checkValidRealm();
            this.checkConcurrentModification();
            return this.cursor != RealmList.this.size();
        }

        @Override
        @Nullable
        public E next() {
            RealmList.this.checkValidRealm();
            this.checkConcurrentModification();
            int i = this.cursor;
            try {
                Object next = RealmList.this.get(i);
                this.lastRet = i;
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkConcurrentModification();
                throw new NoSuchElementException("Cannot access index " + i + " when size is " + RealmList.this.size() + ". Remember to check hasNext() before using next().");
            }
        }

        @Override
        public void remove() {
            RealmList.this.checkValidRealm();
            if (this.lastRet < 0) {
                throw new IllegalStateException("Cannot call remove() twice. Must call next() in between.");
            }
            this.checkConcurrentModification();
            try {
                RealmList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = RealmList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkConcurrentModification() {
            if (RealmList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

