/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Case;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.Table;
import io.realm.internal.core.DescriptorOrdering;
import io.realm.internal.objectstore.OsKeyPathMapping;
import java.util.Date;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class TableQuery
implements NativeObject {
    private static final boolean DEBUG = false;
    private static final long nativeFinalizerPtr = TableQuery.nativeGetFinalizerPtr();
    private final NativeContext context;
    private final Table table;
    private final long nativePtr;
    private boolean queryValidated = true;
    private static final String DATE_NULL_ERROR_MESSAGE = "Date value in query criteria must not be null.";

    public TableQuery(NativeContext context, Table table, long nativeQueryPtr) {
        this.context = context;
        this.table = table;
        this.nativePtr = nativeQueryPtr;
        context.addReference(this);
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    public Table getTable() {
        return this.table;
    }

    void validateQuery() {
        if (!this.queryValidated) {
            String invalidMessage = this.nativeValidateQuery(this.nativePtr);
            if (invalidMessage.equals("")) {
                this.queryValidated = true;
            } else {
                throw new UnsupportedOperationException(invalidMessage);
            }
        }
    }

    public TableQuery group() {
        this.nativeGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endGroup() {
        this.nativeEndGroup(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery or() {
        this.nativeOr(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery not() {
        this.nativeNot(this.nativePtr);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, long value) {
        this.nativeEqual(this.nativePtr, columnKeys, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKey, long[] tablePtrs, long value) {
        this.nativeNotEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKey, long[] tablePtrs, long value) {
        this.nativeGreater(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKey, long[] tablePtrs, long value) {
        this.nativeGreaterEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKey, long[] tablePtrs, long value) {
        this.nativeLess(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKey, long[] tablePtrs, long value) {
        this.nativeLessEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnKey, long value1, long value2) {
        this.nativeBetween(this.nativePtr, columnKey, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeNotEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeGreater(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeGreaterEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeLess(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKey, long[] tablePtrs, float value) {
        this.nativeLessEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnKey, float value1, float value2) {
        this.nativeBetween(this.nativePtr, columnKey, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeNotEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeGreater(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeGreaterEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeLess(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKey, long[] tablePtrs, double value) {
        this.nativeLessEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnKey, double value1, double value2) {
        this.nativeBetween(this.nativePtr, columnKey, value1, value2);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKey, long[] tablePtrs, boolean value) {
        this.nativeEqual(this.nativePtr, columnKey, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKey, long[] tablePtrs, @Nullable Date value) {
        if (value == null) {
            this.nativeIsNull(this.nativePtr, columnKey, tablePtrs);
        } else {
            this.nativeEqualTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        }
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKey, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeNotEqualTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKey, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKey, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeGreaterEqualTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKey, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKey, long[] tablePtrs, Date value) {
        if (value == null) {
            throw new IllegalArgumentException(DATE_NULL_ERROR_MESSAGE);
        }
        this.nativeLessEqualTimestamp(this.nativePtr, columnKey, tablePtrs, value.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnKey, Date value1, Date value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Date values in query criteria must not be null.");
        }
        this.nativeBetweenTimestamp(this.nativePtr, columnKey, value1.getTime(), value2.getTime());
        this.queryValidated = false;
        return this;
    }

    public TableQuery between(long[] columnKey, Decimal128 value1, Decimal128 value2) {
        if (value1 == null || value2 == null) {
            throw new IllegalArgumentException("Decimal128 values in query criteria must not be null.");
        }
        this.nativeBetweenDecimal128(this.nativePtr, columnKey, value1.getLow(), value1.getHigh(), value2.getLow(), value2.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, byte[] value) {
        this.nativeEqual(this.nativePtr, columnKeys, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKeys, long[] tablePtrs, byte[] value) {
        this.nativeNotEqual(this.nativePtr, columnKeys, tablePtrs, value);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, @Nullable String value, Case caseSensitive) {
        this.nativeEqual(this.nativePtr, columnKeys, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, String value) {
        this.nativeEqual(this.nativePtr, columnKeys, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, @Nullable String value, Case caseSensitive) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnIndex, long[] tablePtrs, @Nullable String value) {
        this.nativeNotEqual(this.nativePtr, columnIndex, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnKeys, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeBeginsWith(this.nativePtr, columnKeys, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery beginsWith(long[] columnKeys, long[] tablePtrs, String value) {
        this.nativeBeginsWith(this.nativePtr, columnKeys, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnKeys, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeEndsWith(this.nativePtr, columnKeys, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery endsWith(long[] columnKeys, long[] tablePtrs, String value) {
        this.nativeEndsWith(this.nativePtr, columnKeys, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery like(long[] columnKeys, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeLike(this.nativePtr, columnKeys, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery like(long[] columnKeys, long[] tablePtrs, String value) {
        this.nativeLike(this.nativePtr, columnKeys, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnKeys, long[] tablePtrs, String value, Case caseSensitive) {
        this.nativeContains(this.nativePtr, columnKeys, tablePtrs, value, caseSensitive.getValue());
        this.queryValidated = false;
        return this;
    }

    public TableQuery contains(long[] columnKeys, long[] tablePtrs, String value) {
        this.nativeContains(this.nativePtr, columnKeys, tablePtrs, value, true);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isEmpty(long[] columnKeys, long[] tablePtrs) {
        this.nativeIsEmpty(this.nativePtr, columnKeys, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotEmpty(long[] columnKeys, long[] tablePtrs) {
        this.nativeIsNotEmpty(this.nativePtr, columnKeys, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeEqualDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeNotEqualDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeLessDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeLessEqualDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeGreaterDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKeys, long[] tablePtrs, Decimal128 value) {
        this.nativeGreaterEqualDecimal128(this.nativePtr, columnKeys, tablePtrs, value.getLow(), value.getHigh());
        this.queryValidated = false;
        return this;
    }

    public TableQuery equalTo(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeEqualObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public TableQuery notEqualTo(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeNotEqualObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThan(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeLessObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public TableQuery lessThanOrEqual(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeLessEqualObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThan(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeGreaterObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public TableQuery greaterThanOrEqual(long[] columnKeys, long[] tablePtrs, ObjectId value) {
        this.nativeGreaterEqualObjectId(this.nativePtr, columnKeys, tablePtrs, value.toString());
        this.queryValidated = false;
        return this;
    }

    public long find() {
        this.validateQuery();
        return this.nativeFind(this.nativePtr);
    }

    public long sumInt(long columnKey) {
        this.validateQuery();
        return this.nativeSumInt(this.nativePtr, columnKey);
    }

    public Long maximumInt(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumInt(this.nativePtr, columnKey);
    }

    public Long minimumInt(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumInt(this.nativePtr, columnKey);
    }

    public double averageInt(long columnKey) {
        this.validateQuery();
        return this.nativeAverageInt(this.nativePtr, columnKey);
    }

    public double sumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeSumFloat(this.nativePtr, columnKey);
    }

    public Float maximumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumFloat(this.nativePtr, columnKey);
    }

    public Float minimumFloat(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumFloat(this.nativePtr, columnKey);
    }

    public double averageFloat(long columnKey) {
        this.validateQuery();
        return this.nativeAverageFloat(this.nativePtr, columnKey);
    }

    public double sumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeSumDouble(this.nativePtr, columnKey);
    }

    public Decimal128 sumDecimal128(long columnKey) {
        this.validateQuery();
        long[] data = this.nativeSumDecimal128(this.nativePtr, columnKey);
        if (data != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
        }
        return null;
    }

    public Double maximumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeMaximumDouble(this.nativePtr, columnKey);
    }

    public Double minimumDouble(long columnKey) {
        this.validateQuery();
        return this.nativeMinimumDouble(this.nativePtr, columnKey);
    }

    public double averageDouble(long columnKey) {
        this.validateQuery();
        return this.nativeAverageDouble(this.nativePtr, columnKey);
    }

    public Decimal128 averageDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeAverageDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    public Decimal128 maximumDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeMaximumDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    public Date maximumDate(long columnKey) {
        this.validateQuery();
        Long result = this.nativeMaximumTimestamp(this.nativePtr, columnKey);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Date minimumDate(long columnKey) {
        this.validateQuery();
        Long result = this.nativeMinimumTimestamp(this.nativePtr, columnKey);
        if (result != null) {
            return new Date(result);
        }
        return null;
    }

    public Decimal128 minimumDecimal128(long columnKey) {
        this.validateQuery();
        long[] result = this.nativeMinimumDecimal128(this.nativePtr, columnKey);
        if (result != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)result[1], (long)result[0]);
        }
        return null;
    }

    public TableQuery isNull(long[] columnKeys, long[] tablePtrs) {
        this.nativeIsNull(this.nativePtr, columnKeys, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    public TableQuery isNotNull(long[] columnKeys, long[] tablePtrs) {
        this.nativeIsNotNull(this.nativePtr, columnKeys, tablePtrs);
        this.queryValidated = false;
        return this;
    }

    @Deprecated
    public long count() {
        this.validateQuery();
        return this.nativeCount(this.nativePtr);
    }

    public void rawPredicate(String filter, @Nullable OsKeyPathMapping mapping, DescriptorOrdering descriptors, String[] args) {
        this.nativeRawPredicate(this.nativePtr, filter, mapping != null ? Long.valueOf(mapping.getNativePtr()) : null, descriptors.getNativePtr(), args);
    }

    public long remove() {
        this.validateQuery();
        if (this.table.isImmutable()) {
            this.throwImmutable();
        }
        return this.nativeRemove(this.nativePtr);
    }

    private void throwImmutable() {
        throw new IllegalStateException("Mutable method call during read transaction.");
    }

    public void alwaysTrue() {
        this.nativeAlwaysTrue(this.nativePtr);
    }

    public void alwaysFalse() {
        this.nativeAlwaysFalse(this.nativePtr);
    }

    private native String nativeValidateQuery(long var1);

    private native void nativeGroup(long var1);

    private native void nativeEndGroup(long var1);

    private native void nativeOr(long var1);

    private native void nativeNot(long var1);

    private native void nativeEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, long var5);

    private native void nativeBetween(long var1, long[] var3, long var4, long var6);

    private native void nativeEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, float var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, float var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, float var5);

    private native void nativeBetween(long var1, long[] var3, float var4, float var5);

    private native void nativeEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeGreater(long var1, long[] var3, long[] var4, double var5);

    private native void nativeGreaterEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeLess(long var1, long[] var3, long[] var4, double var5);

    private native void nativeLessEqual(long var1, long[] var3, long[] var4, double var5);

    private native void nativeBetween(long var1, long[] var3, double var4, double var6);

    private native void nativeEqual(long var1, long[] var3, long[] var4, boolean var5);

    private native void nativeEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeNotEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeGreaterEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeLessEqualTimestamp(long var1, long[] var3, long[] var4, long var5);

    private native void nativeBetweenTimestamp(long var1, long[] var3, long var4, long var6);

    private native void nativeBetweenDecimal128(long var1, long[] var3, long var4, long var6, long var8, long var10);

    private native void nativeEqual(long var1, long[] var3, long[] var4, byte[] var5);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, byte[] var5);

    private native void nativeEqual(long var1, long[] var3, long[] var4, @Nullable String var5, boolean var6);

    private native void nativeNotEqual(long var1, long[] var3, long[] var4, @Nullable String var5, boolean var6);

    private native void nativeBeginsWith(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeEndsWith(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeLike(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeContains(long var1, long[] var3, long[] var4, String var5, boolean var6);

    private native void nativeEqualDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeNotEqualDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeGreaterDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeGreaterEqualDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeLessDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeLessEqualDecimal128(long var1, long[] var3, long[] var4, long var5, long var7);

    private native void nativeEqualObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeNotEqualObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeGreaterObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeGreaterEqualObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeLessObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeLessEqualObjectId(long var1, long[] var3, long[] var4, String var5);

    private native void nativeIsEmpty(long var1, long[] var3, long[] var4);

    private native void nativeIsNotEmpty(long var1, long[] var3, long[] var4);

    private native void nativeAlwaysTrue(long var1);

    private native void nativeAlwaysFalse(long var1);

    private native long nativeFind(long var1);

    private native long nativeSumInt(long var1, long var3);

    private native Long nativeMaximumInt(long var1, long var3);

    private native Long nativeMinimumInt(long var1, long var3);

    private native double nativeAverageInt(long var1, long var3);

    private native double nativeSumFloat(long var1, long var3);

    private native Float nativeMaximumFloat(long var1, long var3);

    private native Float nativeMinimumFloat(long var1, long var3);

    private native double nativeAverageFloat(long var1, long var3);

    private native double nativeSumDouble(long var1, long var3);

    private native long[] nativeSumDecimal128(long var1, long var3);

    private native Double nativeMaximumDouble(long var1, long var3);

    private native long[] nativeMaximumDecimal128(long var1, long var3);

    private native Double nativeMinimumDouble(long var1, long var3);

    private native long[] nativeMinimumDecimal128(long var1, long var3);

    private native double nativeAverageDouble(long var1, long var3);

    private native long[] nativeAverageDecimal128(long var1, long var3);

    private native Long nativeMaximumTimestamp(long var1, long var3);

    private native Long nativeMinimumTimestamp(long var1, long var3);

    private native void nativeIsNull(long var1, long[] var3, long[] var4);

    private native void nativeIsNotNull(long var1, long[] var3, long[] var4);

    private native long nativeCount(long var1);

    private native long nativeRemove(long var1);

    private native void nativeRawPredicate(long var1, String var3, Long var4, long var5, String[] var7);

    private static native long nativeGetFinalizerPtr();
}

