/*
 * Decompiled with CFR 0.152.
 */
package io.realm.rx;

import android.os.Looper;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposables;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.ObjectChangeSet;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectChangeListener;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import io.realm.rx.CollectionChange;
import io.realm.rx.ObjectChange;
import io.realm.rx.RxObservableFactory;
import java.util.IdentityHashMap;
import java.util.Map;

public class RealmObservableFactory
implements RxObservableFactory {
    private final boolean returnFrozenObjects;
    private ThreadLocal<StrongReferenceCounter<RealmResults>> resultsRefs = new ThreadLocal<StrongReferenceCounter<RealmResults>>(){

        @Override
        protected StrongReferenceCounter<RealmResults> initialValue() {
            return new StrongReferenceCounter<RealmResults>();
        }
    };
    private ThreadLocal<StrongReferenceCounter<RealmList>> listRefs = new ThreadLocal<StrongReferenceCounter<RealmList>>(){

        @Override
        protected StrongReferenceCounter<RealmList> initialValue() {
            return new StrongReferenceCounter<RealmList>();
        }
    };
    private ThreadLocal<StrongReferenceCounter<RealmModel>> objectRefs = new ThreadLocal<StrongReferenceCounter<RealmModel>>(){

        @Override
        protected StrongReferenceCounter<RealmModel> initialValue() {
            return new StrongReferenceCounter<RealmModel>();
        }
    };
    private static final BackpressureStrategy BACK_PRESSURE_STRATEGY = BackpressureStrategy.LATEST;

    @Override
    public Flowable<Realm> from(Realm realm) {
        if (realm.isFrozen()) {
            return Flowable.just((Object)realm);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Realm>(){

            public void subscribe(final FlowableEmitter<Realm> emitter) throws Exception {
                final Realm observableRealm = Realm.getInstance(realmConfig);
                final RealmChangeListener<Realm> listener2 = new RealmChangeListener<Realm>(){

                    @Override
                    public void onChange(Realm realm) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? realm.freeze() : realm));
                        }
                    }
                };
                observableRealm.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            observableRealm.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? observableRealm.freeze() : observableRealm));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    public RealmObservableFactory(boolean emitFrozenObjects) {
        this.returnFrozenObjects = emitFrozenObjects;
    }

    @Override
    public Flowable<DynamicRealm> from(DynamicRealm realm) {
        if (realm.isFrozen()) {
            return Flowable.just((Object)realm);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<DynamicRealm>(){

            public void subscribe(final FlowableEmitter<DynamicRealm> emitter) throws Exception {
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                final RealmChangeListener<DynamicRealm> listener2 = new RealmChangeListener<DynamicRealm>(){

                    @Override
                    public void onChange(DynamicRealm realm) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? realm.freeze() : realm));
                        }
                    }
                };
                observableRealm.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            observableRealm.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? observableRealm.freeze() : observableRealm));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Flowable<RealmResults<E>> from(Realm realm, final RealmResults<E> results) {
        if (realm.isFrozen()) {
            return Flowable.just(results);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmResults<E>>(){

            public void subscribe(final FlowableEmitter<RealmResults<E>> emitter) {
                if (!results.isValid()) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final RealmChangeListener listener2 = new RealmChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results);
                        }
                    }
                };
                results.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            results.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    private Scheduler getScheduler() {
        Looper looper = Looper.myLooper();
        if (looper == null) {
            throw new IllegalStateException("No looper found");
        }
        return AndroidSchedulers.from((Looper)looper);
    }

    @Override
    public <E> Observable<CollectionChange<RealmResults<E>>> changesetsFrom(Realm realm, final RealmResults<E> results) {
        if (realm.isFrozen()) {
            return Observable.just(new CollectionChange<RealmResults<E>>(results, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmResults<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmResults<E>>> emitter) {
                if (!results.isValid()) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final OrderedRealmCollectionChangeListener listener2 = new OrderedRealmCollectionChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> e, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange<RealmResults>((RealmResults)(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results), changeSet));
                        }
                    }
                };
                results.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            results.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmResults>((RealmResults)(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results), null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Flowable<RealmResults<E>> from(DynamicRealm realm, final RealmResults<E> results) {
        if (realm.isFrozen()) {
            return Flowable.just(results);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmResults<E>>(){

            public void subscribe(final FlowableEmitter<RealmResults<E>> emitter) {
                if (!results.isValid()) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final RealmChangeListener listener2 = new RealmChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results);
                        }
                    }
                };
                results.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            results.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Observable<CollectionChange<RealmResults<E>>> changesetsFrom(DynamicRealm realm, final RealmResults<E> results) {
        if (realm.isFrozen()) {
            return Observable.just(new CollectionChange<RealmResults<E>>(results, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmResults<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmResults<E>>> emitter) {
                if (!results.isValid()) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).acquireReference(results);
                final OrderedRealmCollectionChangeListener listener2 = new OrderedRealmCollectionChangeListener<RealmResults<E>>(){

                    @Override
                    public void onChange(RealmResults<E> results, OrderedCollectionChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results, changeSet));
                        }
                    }
                };
                results.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            results.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.resultsRefs.get()).releaseReference(results);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmResults>((RealmResults)(RealmObservableFactory.this.returnFrozenObjects ? results.freeze() : results), null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Flowable<RealmList<E>> from(Realm realm, final RealmList<E> list) {
        if (realm.isFrozen()) {
            return Flowable.just(list);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmList<E>>(){

            public void subscribe(final FlowableEmitter<RealmList<E>> emitter) {
                if (!list.isValid()) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final RealmChangeListener listener2 = new RealmChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> list) {
                        if (!list.isValid()) {
                            emitter.onComplete();
                            return;
                        }
                        if (!emitter.isCancelled()) {
                            emitter.onNext(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list);
                        }
                    }
                };
                list.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            list.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Observable<CollectionChange<RealmList<E>>> changesetsFrom(Realm realm, final RealmList<E> list) {
        if (realm.isFrozen()) {
            return Observable.just(new CollectionChange<RealmList<E>>(list, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmList<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmList<E>>> emitter) {
                if (!list.isValid()) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final OrderedRealmCollectionChangeListener listener2 = new OrderedRealmCollectionChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> list, OrderedCollectionChangeSet changeSet) {
                        if (!list.isValid()) {
                            emitter.onComplete();
                            return;
                        }
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list, changeSet));
                        }
                    }
                };
                list.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            list.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmList>((RealmList)(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list), null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Flowable<RealmList<E>> from(DynamicRealm realm, final RealmList<E> list) {
        if (realm.isFrozen()) {
            return Flowable.just(list);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<RealmList<E>>(){

            public void subscribe(final FlowableEmitter<RealmList<E>> emitter) {
                if (!list.isValid()) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final RealmChangeListener listener2 = new RealmChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> list) {
                        if (!list.isValid()) {
                            emitter.onComplete();
                            return;
                        }
                        if (!emitter.isCancelled()) {
                            emitter.onNext(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list);
                        }
                    }
                };
                list.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            list.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Observable<CollectionChange<RealmList<E>>> changesetsFrom(DynamicRealm realm, final RealmList<E> list) {
        if (realm.isFrozen()) {
            return Observable.just(new CollectionChange<RealmList<E>>(list, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<CollectionChange<RealmList<E>>>(){

            public void subscribe(final ObservableEmitter<CollectionChange<RealmList<E>>> emitter) {
                if (!list.isValid()) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).acquireReference(list);
                final OrderedRealmCollectionChangeListener listener2 = new OrderedRealmCollectionChangeListener<RealmList<E>>(){

                    @Override
                    public void onChange(RealmList<E> list, OrderedCollectionChangeSet changeSet) {
                        if (!list.isValid()) {
                            emitter.onComplete();
                            return;
                        }
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new CollectionChange(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list, changeSet));
                        }
                    }
                };
                list.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            list.removeChangeListener(listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.listRefs.get()).releaseReference(list);
                    }
                }));
                emitter.onNext(new CollectionChange<RealmList>((RealmList)(RealmObservableFactory.this.returnFrozenObjects ? list.freeze() : list), null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E extends RealmModel> Flowable<E> from(final Realm realm, final E object) {
        if (realm.isFrozen()) {
            return Flowable.just(object);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<E>(){

            public void subscribe(final FlowableEmitter<E> emitter) {
                if (realm.isClosed()) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmChangeListener listener2 = new RealmChangeListener<E>(){

                    @Override
                    public void onChange(E obj) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(obj) : obj);
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            RealmObject.removeChangeListener(object, listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(object) : object));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E extends RealmModel> Observable<ObjectChange<E>> changesetsFrom(Realm realm, final E object) {
        if (realm.isFrozen()) {
            return Observable.just(new ObjectChange<E>(object, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ObjectChange<E>>(){

            public void subscribe(final ObservableEmitter<ObjectChange<E>> emitter) {
                if (!RealmObject.isValid(object)) {
                    return;
                }
                final Realm observableRealm = Realm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmObjectChangeListener listener2 = new RealmObjectChangeListener<E>(){

                    @Override
                    public void onChange(E obj, ObjectChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new ObjectChange(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(obj) : obj, changeSet));
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            RealmObject.removeChangeListener(object, listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext(new ObjectChange<RealmModel>(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(object) : object, null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public Flowable<DynamicRealmObject> from(final DynamicRealm realm, final DynamicRealmObject object) {
        if (realm.isFrozen()) {
            return Flowable.just((Object)object);
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<DynamicRealmObject>(){

            public void subscribe(final FlowableEmitter<DynamicRealmObject> emitter) {
                if (realm.isClosed()) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmChangeListener<DynamicRealmObject> listener2 = new RealmChangeListener<DynamicRealmObject>(){

                    @Override
                    public void onChange(DynamicRealmObject obj) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(obj) : obj));
                        }
                    }
                };
                RealmObject.addChangeListener(object, listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            RealmObject.removeChangeListener(object, listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext((Object)(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(object) : object));
            }
        }, (BackpressureStrategy)BACK_PRESSURE_STRATEGY).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public Observable<ObjectChange<DynamicRealmObject>> changesetsFrom(DynamicRealm realm, final DynamicRealmObject object) {
        if (realm.isFrozen()) {
            return Observable.just(new ObjectChange<DynamicRealmObject>(object, null));
        }
        final RealmConfiguration realmConfig = realm.getConfiguration();
        Scheduler scheduler = this.getScheduler();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ObjectChange<DynamicRealmObject>>(){

            public void subscribe(final ObservableEmitter<ObjectChange<DynamicRealmObject>> emitter) {
                if (!RealmObject.isValid(object)) {
                    return;
                }
                final DynamicRealm observableRealm = DynamicRealm.getInstance(realmConfig);
                ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).acquireReference(object);
                final RealmObjectChangeListener<DynamicRealmObject> listener2 = new RealmObjectChangeListener<DynamicRealmObject>(){

                    @Override
                    public void onChange(DynamicRealmObject obj, ObjectChangeSet changeSet) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(new ObjectChange<DynamicRealmObject>(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(obj) : obj, changeSet));
                        }
                    }
                };
                object.addChangeListener(listener2);
                emitter.setDisposable(Disposables.fromRunnable((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!observableRealm.isClosed()) {
                            RealmObject.removeChangeListener(object, listener2);
                            observableRealm.close();
                        }
                        ((StrongReferenceCounter)RealmObservableFactory.this.objectRefs.get()).releaseReference(object);
                    }
                }));
                emitter.onNext(new ObjectChange<DynamicRealmObject>(RealmObservableFactory.this.returnFrozenObjects ? RealmObject.freeze(object) : object, null));
            }
        }).subscribeOn(scheduler).unsubscribeOn(scheduler);
    }

    @Override
    public <E> Single<RealmQuery<E>> from(Realm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    @Override
    public <E> Single<RealmQuery<E>> from(DynamicRealm realm, RealmQuery<E> query) {
        throw new RuntimeException("RealmQuery not supported yet.");
    }

    public boolean equals(Object o) {
        return o instanceof RealmObservableFactory;
    }

    public int hashCode() {
        return 37;
    }

    private static class StrongReferenceCounter<K> {
        private final Map<K, Integer> references = new IdentityHashMap<K, Integer>();

        private StrongReferenceCounter() {
        }

        public void acquireReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                this.references.put(object, 1);
            } else {
                this.references.put(object, count + 1);
            }
        }

        public void releaseReference(K object) {
            Integer count = this.references.get(object);
            if (count == null) {
                throw new IllegalStateException("Object does not have any references: " + object);
            }
            if (count > 1) {
                this.references.put(object, count - 1);
            } else if (count == 1) {
                this.references.remove(object);
            } else {
                throw new IllegalStateException("Invalid reference count: " + count);
            }
        }
    }
}

