/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.ProxyState;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmModel;
import io.realm.RealmObjectChangeListener;
import io.realm.annotations.RealmClass;
import io.realm.internal.InvalidRow;
import io.realm.internal.ManageableObject;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.log.RealmLog;
import io.realm.rx.ObjectChange;
import java.util.Collections;
import javax.annotation.Nullable;

@RealmClass
public abstract class RealmObject
implements RealmModel,
ManageableObject {
    static final String MSG_NULL_OBJECT = "'model' is null.";
    static final String MSG_DELETED_OBJECT = "the object is already deleted.";
    static final String MSG_DYNAMIC_OBJECT = "the object is an instance of DynamicRealmObject. Use DynamicRealmObject.getDynamicRealm() instead.";

    public final void deleteFromRealm() {
        RealmObject.deleteFromRealm(this);
    }

    public static <E extends RealmModel> void deleteFromRealm(E object) {
        if (!(object instanceof RealmObjectProxy)) {
            throw new IllegalArgumentException("Object not managed by Realm, so it cannot be removed.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)object;
        if (proxy.realmGet$proxyState().getRow$realm() == null) {
            throw new IllegalStateException("Object malformed: missing object in Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        if (proxy.realmGet$proxyState().getRealm$realm() == null) {
            throw new IllegalStateException("Object malformed: missing Realm. Make sure to instantiate RealmObjects with Realm.createObject()");
        }
        proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
        Row row = proxy.realmGet$proxyState().getRow$realm();
        row.getTable().moveLastOver(row.getObjectKey());
        proxy.realmGet$proxyState().setRow$realm(InvalidRow.INSTANCE);
    }

    @Override
    public final boolean isValid() {
        return RealmObject.isValid(this);
    }

    public static <E extends RealmModel> boolean isValid(@Nullable E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            Row row = proxy.realmGet$proxyState().getRow$realm();
            return row != null && row.isValid();
        }
        return object != null;
    }

    @Override
    public final boolean isFrozen() {
        return RealmObject.isFrozen(this);
    }

    public final <E extends RealmModel> E freeze() {
        return (E)RealmObject.freeze(this);
    }

    public static <E extends RealmModel> boolean isFrozen(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            return proxy.realmGet$proxyState().getRealm$realm().isFrozen();
        }
        return false;
    }

    public static <E extends RealmModel> E freeze(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            BaseRealm frozenRealm = realm.isFrozen() ? realm : realm.freeze();
            Row frozenRow = proxy.realmGet$proxyState().getRow$realm().freeze(frozenRealm.sharedRealm);
            if (frozenRealm instanceof DynamicRealm) {
                return (E)new DynamicRealmObject(frozenRealm, frozenRow);
            }
            if (frozenRealm instanceof Realm) {
                Class<?> modelClass = object.getClass().getSuperclass();
                return (E)frozenRealm.getConfiguration().getSchemaMediator().newInstance(modelClass, frozenRealm, frozenRow, realm.getSchema().getColumnInfo(modelClass), false, Collections.emptyList());
            }
            throw new UnsupportedOperationException("Unknown Realm type: " + frozenRealm.getClass().getName());
        }
        throw new IllegalArgumentException("It is only possible to freeze valid managed Realm objects.");
    }

    public final boolean isLoaded() {
        return RealmObject.isLoaded(this);
    }

    public static <E extends RealmModel> boolean isLoaded(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            proxy.realmGet$proxyState().getRealm$realm().checkIfValid();
            return proxy.realmGet$proxyState().isLoaded();
        }
        return true;
    }

    @Override
    public boolean isManaged() {
        return RealmObject.isManaged(this);
    }

    public static <E extends RealmModel> boolean isManaged(E object) {
        return object instanceof RealmObjectProxy;
    }

    public Realm getRealm() {
        return RealmObject.getRealm(this);
    }

    public static Realm getRealm(RealmModel model) {
        if (model == null) {
            throw new IllegalArgumentException(MSG_NULL_OBJECT);
        }
        if (model instanceof DynamicRealmObject) {
            throw new IllegalStateException(MSG_DYNAMIC_OBJECT);
        }
        if (!(model instanceof RealmObjectProxy)) {
            return null;
        }
        BaseRealm realm = ((RealmObjectProxy)model).realmGet$proxyState().getRealm$realm();
        realm.checkIfValid();
        if (!RealmObject.isValid(model)) {
            throw new IllegalStateException(MSG_DELETED_OBJECT);
        }
        return (Realm)realm;
    }

    public final boolean load() {
        return RealmObject.load(this);
    }

    public static <E extends RealmModel> boolean load(E object) {
        if (RealmObject.isLoaded(object)) {
            return true;
        }
        if (object instanceof RealmObjectProxy) {
            ((RealmObjectProxy)object).realmGet$proxyState().load();
            return true;
        }
        return false;
    }

    public final <E extends RealmModel> void addChangeListener(RealmObjectChangeListener<E> listener2) {
        RealmObject.addChangeListener(this, listener2);
    }

    public final <E extends RealmModel> void addChangeListener(RealmChangeListener<E> listener2) {
        RealmObject.addChangeListener(this, listener2);
    }

    public static <E extends RealmModel> void addChangeListener(E object, RealmObjectChangeListener<E> listener2) {
        if (object == null) {
            throw new IllegalArgumentException("Object should not be null");
        }
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (!(object instanceof RealmObjectProxy)) {
            throw new IllegalArgumentException("Cannot add listener from this unmanaged RealmObject (created outside of Realm)");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)object;
        BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
        realm.checkIfValid();
        realm.sharedRealm.capabilities.checkCanDeliverNotification("Listeners cannot be used on current thread.");
        proxy.realmGet$proxyState().addChangeListener(listener2);
    }

    public static <E extends RealmModel> void addChangeListener(E object, RealmChangeListener<E> listener2) {
        RealmObject.addChangeListener(object, new ProxyState.RealmChangeListenerWrapper<E>(listener2));
    }

    public final void removeChangeListener(RealmObjectChangeListener listener2) {
        RealmObject.removeChangeListener(this, listener2);
    }

    public final void removeChangeListener(RealmChangeListener listener2) {
        RealmObject.removeChangeListener(this, listener2);
    }

    public static <E extends RealmModel> void removeChangeListener(E object, RealmObjectChangeListener listener2) {
        RealmObjectProxy proxy;
        if (object == null) {
            throw new IllegalArgumentException("Object should not be null");
        }
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (object instanceof RealmObjectProxy) {
            proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            if (realm.isClosed()) {
                RealmLog.warn("Calling removeChangeListener on a closed Realm %s, make sure to close all listeners before closing the Realm.", realm.configuration.getPath());
            }
        } else {
            throw new IllegalArgumentException("Cannot remove listener from this unmanaged RealmObject (created outside of Realm)");
        }
        proxy.realmGet$proxyState().removeChangeListener(listener2);
    }

    public static <E extends RealmModel> void removeChangeListener(E object, RealmChangeListener<E> listener2) {
        RealmObject.removeChangeListener(object, new ProxyState.RealmChangeListenerWrapper<E>(listener2));
    }

    public final void removeAllChangeListeners() {
        RealmObject.removeAllChangeListeners(this);
    }

    public static <E extends RealmModel> void removeAllChangeListeners(E object) {
        RealmObjectProxy proxy;
        if (object instanceof RealmObjectProxy) {
            proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            if (realm.isClosed()) {
                RealmLog.warn("Calling removeChangeListener on a closed Realm %s, make sure to close all listeners before closing the Realm.", realm.configuration.getPath());
            }
        } else {
            throw new IllegalArgumentException("Cannot remove listeners from this unmanaged RealmObject (created outside of Realm)");
        }
        proxy.realmGet$proxyState().removeAllChangeListeners();
    }

    public final <E extends RealmObject> Flowable<E> asFlowable() {
        return RealmObject.asFlowable(this);
    }

    public final <E extends RealmObject> Observable<ObjectChange<E>> asChangesetObservable() {
        return RealmObject.asChangesetObservable(this);
    }

    public static <E extends RealmModel> Flowable<E> asFlowable(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            if (realm instanceof Realm) {
                return realm.configuration.getRxFactory().from((Realm)realm, object);
            }
            if (realm instanceof DynamicRealm) {
                DynamicRealm dynamicRealm = (DynamicRealm)realm;
                DynamicRealmObject dynamicObject = (DynamicRealmObject)object;
                Flowable<DynamicRealmObject> observable = realm.configuration.getRxFactory().from(dynamicRealm, dynamicObject);
                return observable;
            }
            throw new UnsupportedOperationException(realm.getClass() + " does not support RxJava. See https://realm.io/docs/java/latest/#rxjava for more details.");
        }
        throw new IllegalArgumentException("Cannot create Observables from unmanaged RealmObjects");
    }

    public static <E extends RealmModel> Observable<ObjectChange<E>> asChangesetObservable(E object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            BaseRealm realm = proxy.realmGet$proxyState().getRealm$realm();
            if (realm instanceof Realm) {
                return realm.configuration.getRxFactory().changesetsFrom((Realm)realm, object);
            }
            if (realm instanceof DynamicRealm) {
                DynamicRealm dynamicRealm = (DynamicRealm)realm;
                DynamicRealmObject dynamicObject = (DynamicRealmObject)object;
                return realm.configuration.getRxFactory().changesetsFrom(dynamicRealm, dynamicObject);
            }
            throw new UnsupportedOperationException(realm.getClass() + " does not support RxJava. See https://realm.io/docs/java/latest/#rxjava for more details.");
        }
        throw new IllegalArgumentException("Cannot create Observables from unmanaged RealmObjects");
    }
}

