/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.fields;

import io.realm.RealmFieldType;
import io.realm.internal.ColumnInfo;
import io.realm.internal.fields.FieldDescriptor;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class CachedFieldDescriptor
extends FieldDescriptor {
    private final FieldDescriptor.SchemaProxy schema;
    private final String className;

    CachedFieldDescriptor(FieldDescriptor.SchemaProxy schema, String className, String fieldDescription, Set<RealmFieldType> validInternalColumnTypes, Set<RealmFieldType> validFinalColumnTypes) {
        super(fieldDescription, validInternalColumnTypes, validFinalColumnTypes);
        this.className = className;
        this.schema = schema;
    }

    @Override
    protected void compileFieldDescription(List<String> fields) {
        int nFields = fields.size();
        long[] columnKeys = new long[nFields];
        long[] tableNativePointers = new long[nFields];
        String currentClassName = this.className;
        String currentColumnName = null;
        RealmFieldType currentColumnType = null;
        for (int i = 0; i < nFields; ++i) {
            currentColumnName = fields.get(i);
            if (currentColumnName == null || currentColumnName.length() <= 0) {
                throw new IllegalArgumentException("Invalid query: Field descriptor contains an empty field.  A field description may not begin with or contain adjacent periods ('.').");
            }
            ColumnInfo columnInfo = this.schema.getColumnInfo(currentClassName);
            if (columnInfo == null) {
                throw new IllegalArgumentException(String.format(Locale.US, "Invalid query: class '%s' not found in this schema.", currentClassName));
            }
            ColumnInfo.ColumnDetails details = columnInfo.getColumnDetails(currentColumnName);
            if (details == null) {
                throw new IllegalArgumentException(String.format(Locale.US, "Invalid query: field '%s' not found in class '%s'.", currentColumnName, currentClassName));
            }
            currentColumnType = details.columnType;
            if (i < nFields - 1) {
                this.verifyInternalColumnType(currentClassName, currentColumnName, currentColumnType);
                currentClassName = details.linkedClassName;
            }
            columnKeys[i] = details.columnKey;
            tableNativePointers[i] = currentColumnType != RealmFieldType.LINKING_OBJECTS ? 0L : this.schema.getNativeTablePtr(details.linkedClassName);
        }
        this.setCompilationResults(currentClassName, currentColumnName, currentColumnType, columnKeys, tableNativePointers);
    }
}

