/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.fields;

import io.realm.RealmFieldType;
import io.realm.internal.Table;
import io.realm.internal.fields.FieldDescriptor;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class DynamicFieldDescriptor
extends FieldDescriptor {
    private final Table table;

    DynamicFieldDescriptor(Table table, String fieldDescription, Set<RealmFieldType> validInternalColumnTypes, Set<RealmFieldType> validFinalColumnTypes) {
        super(fieldDescription, validInternalColumnTypes, validFinalColumnTypes);
        this.table = table;
    }

    @Override
    protected void compileFieldDescription(List<String> fields) {
        int nFields = fields.size();
        long[] columnKeys = new long[nFields];
        Table currentTable = this.table;
        String currentClassName = null;
        String currentColumnName = null;
        RealmFieldType currentColumnType = null;
        for (int i = 0; i < nFields; ++i) {
            currentColumnName = fields.get(i);
            if (currentColumnName == null || currentColumnName.length() <= 0) {
                throw new IllegalArgumentException("Invalid query: Field descriptor contains an empty field.  A field description may not begin with or contain adjacent periods ('.').");
            }
            currentClassName = currentTable.getClassName();
            long columnKey = currentTable.getColumnKey(currentColumnName);
            if (columnKey < 0L) {
                throw new IllegalArgumentException(String.format(Locale.US, "Invalid query: field '%s' not found in table '%s'.", currentColumnName, currentClassName));
            }
            currentColumnType = currentTable.getColumnType(columnKey);
            if (i < nFields - 1) {
                this.verifyInternalColumnType(currentClassName, currentColumnName, currentColumnType);
                currentTable = currentTable.getLinkTarget(columnKey);
            }
            columnKeys[i] = columnKey;
        }
        this.setCompilationResults(currentClassName, currentColumnName, currentColumnType, columnKeys, new long[nFields]);
    }
}

