/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.internal.OsList;
import javax.annotation.Nullable;

abstract class ManagedListOperator<T> {
    static final String NULL_OBJECTS_NOT_ALLOWED_MESSAGE = "RealmList does not accept null values.";
    static final String INVALID_OBJECT_TYPE_MESSAGE = "Unacceptable value type. Acceptable: %1$s, actual: %2$s .";
    final BaseRealm realm;
    final OsList osList;
    @Nullable
    final Class<T> clazz;

    ManagedListOperator(BaseRealm realm, OsList osList, @Nullable Class<T> clazz) {
        this.realm = realm;
        this.clazz = clazz;
        this.osList = osList;
    }

    public abstract boolean forRealmModel();

    public final OsList getOsList() {
        return this.osList;
    }

    public final boolean isValid() {
        return this.osList.isValid();
    }

    public final int size() {
        long actualSize = this.osList.size();
        return actualSize < Integer.MAX_VALUE ? (int)actualSize : Integer.MAX_VALUE;
    }

    public final boolean isEmpty() {
        return this.osList.isEmpty();
    }

    protected abstract void checkValidValue(@Nullable Object var1);

    @Nullable
    public abstract T get(int var1);

    public final void append(@Nullable Object value) {
        this.checkValidValue(value);
        if (value == null) {
            this.appendNull();
        } else {
            this.appendValue(value);
        }
    }

    private void appendNull() {
        this.osList.addNull();
    }

    protected abstract void appendValue(Object var1);

    public final void insert(int index, @Nullable Object value) {
        this.checkValidValue(value);
        if (value == null) {
            this.insertNull(index);
        } else {
            this.insertValue(index, value);
        }
    }

    protected void insertNull(int index) {
        this.osList.insertNull(index);
    }

    protected abstract void insertValue(int var1, Object var2);

    @Nullable
    public final T set(int index, @Nullable Object value) {
        this.checkValidValue(value);
        T oldObject = this.get(index);
        if (value == null) {
            this.setNull(index);
        } else {
            this.setValue(index, value);
        }
        return oldObject;
    }

    protected void setNull(int index) {
        this.osList.setNull(index);
    }

    protected abstract void setValue(int var1, Object var2);

    final void move(int oldPos, int newPos) {
        this.osList.move(oldPos, newPos);
    }

    final void remove(int index) {
        this.osList.remove(index);
    }

    final void removeAll() {
        this.osList.removeAll();
    }

    final void delete(int index) {
        this.osList.delete(index);
    }

    final void deleteLast() {
        this.osList.delete(this.osList.size() - 1L);
    }

    final void deleteAll() {
        this.osList.deleteAll();
    }
}

