/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.RealmChangeListener;
import io.realm.internal.Keep;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsCollectionChangeSet;
import io.realm.internal.StatefulCollectionChangeSet;
import javax.annotation.Nullable;

@Keep
interface ObservableCollection {
    public void notifyChangeListeners(long var1);

    public static class Callback
    implements ObserverPairList.Callback<CollectionObserverPair> {
        private final OsCollectionChangeSet changeSet;

        Callback(OsCollectionChangeSet changeSet) {
            this.changeSet = changeSet;
        }

        @Override
        public void onCalled(CollectionObserverPair pair, Object observer) {
            pair.onChange(observer, this.changeSet);
        }
    }

    public static class RealmChangeListenerWrapper<T>
    implements OrderedRealmCollectionChangeListener<T> {
        private final RealmChangeListener<T> listener;

        RealmChangeListenerWrapper(RealmChangeListener<T> listener2) {
            this.listener = listener2;
        }

        @Override
        public void onChange(T collection, @Nullable OrderedCollectionChangeSet changes) {
            this.listener.onChange(collection);
        }

        public boolean equals(Object obj) {
            return obj instanceof RealmChangeListenerWrapper && this.listener == ((RealmChangeListenerWrapper)obj).listener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }

    public static class CollectionObserverPair<T>
    extends ObserverPairList.ObserverPair<T, Object> {
        CollectionObserverPair(T observer, Object listener2) {
            super(observer, listener2);
        }

        public void onChange(T observer, OsCollectionChangeSet changes) {
            if (this.listener instanceof OrderedRealmCollectionChangeListener) {
                ((OrderedRealmCollectionChangeListener)this.listener).onChange(observer, new StatefulCollectionChangeSet(changes));
            } else if (this.listener instanceof RealmChangeListener) {
                ((RealmChangeListener)this.listener).onChange(observer);
            } else {
                throw new RuntimeException("Unsupported listener type: " + this.listener);
            }
        }
    }
}

