/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.CheckedRow;
import io.realm.internal.InvalidRow;
import io.realm.internal.NativeContext;
import io.realm.internal.NativeObject;
import io.realm.internal.OsList;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.Row;
import io.realm.internal.Table;
import java.util.Date;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class UncheckedRow
implements NativeObject,
Row {
    private static final long nativeFinalizerPtr = UncheckedRow.nativeGetFinalizerPtr();
    protected final NativeContext context;
    protected final Table parent;
    private final long nativePtr;

    public UncheckedRow(NativeContext context, Table parent, long nativePtr) {
        this.context = context;
        this.parent = parent;
        this.nativePtr = nativePtr;
        context.addReference(this);
    }

    UncheckedRow(UncheckedRow row) {
        this.context = row.context;
        this.parent = row.parent;
        this.nativePtr = row.nativePtr;
    }

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Override
    public long getNativeFinalizerPtr() {
        return nativeFinalizerPtr;
    }

    static UncheckedRow getByRowKey(NativeContext context, Table table, long rowKey) {
        long nativeRowPointer = table.nativeGetRowPtr(table.getNativePtr(), rowKey);
        return new UncheckedRow(context, table, nativeRowPointer);
    }

    static UncheckedRow getByRowPointer(NativeContext context, Table table, long nativeRowPointer) {
        return new UncheckedRow(context, table, nativeRowPointer);
    }

    @Override
    public long getColumnCount() {
        return this.nativeGetColumnCount(this.nativePtr);
    }

    @Override
    public String[] getColumnNames() {
        return this.nativeGetColumnNames(this.nativePtr);
    }

    @Override
    public long getColumnKey(String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name can not be null.");
        }
        return this.nativeGetColumnKey(this.nativePtr, columnName);
    }

    @Override
    public RealmFieldType getColumnType(long columnKey) {
        return RealmFieldType.fromNativeValue(this.nativeGetColumnType(this.nativePtr, columnKey));
    }

    @Override
    public Table getTable() {
        return this.parent;
    }

    @Override
    public long getObjectKey() {
        return this.nativeGetObjectKey(this.nativePtr);
    }

    @Override
    public long getLong(long columnKey) {
        return this.nativeGetLong(this.nativePtr, columnKey);
    }

    @Override
    public boolean getBoolean(long columnKey) {
        return this.nativeGetBoolean(this.nativePtr, columnKey);
    }

    @Override
    public float getFloat(long columnKey) {
        return this.nativeGetFloat(this.nativePtr, columnKey);
    }

    @Override
    public double getDouble(long columnKey) {
        return this.nativeGetDouble(this.nativePtr, columnKey);
    }

    @Override
    public Date getDate(long columnKey) {
        return new Date(this.nativeGetTimestamp(this.nativePtr, columnKey));
    }

    @Override
    public String getString(long columnKey) {
        return this.nativeGetString(this.nativePtr, columnKey);
    }

    @Override
    public byte[] getBinaryByteArray(long columnKey) {
        return this.nativeGetByteArray(this.nativePtr, columnKey);
    }

    @Override
    public Decimal128 getDecimal128(long columnKey) {
        long[] data = this.nativeGetDecimal128(this.nativePtr, columnKey);
        if (data != null) {
            return Decimal128.fromIEEE754BIDEncoding((long)data[1], (long)data[0]);
        }
        return null;
    }

    @Override
    public ObjectId getObjectId(long columnKey) {
        return new ObjectId(this.nativeGetObjectId(this.nativePtr, columnKey));
    }

    @Override
    public long getLink(long columnKey) {
        return this.nativeGetLink(this.nativePtr, columnKey);
    }

    @Override
    public boolean isNullLink(long columnKey) {
        return this.nativeIsNullLink(this.nativePtr, columnKey);
    }

    @Override
    public OsList getModelList(long columnKey) {
        return new OsList(this, columnKey);
    }

    @Override
    public OsList getValueList(long columnKey, RealmFieldType fieldType) {
        return new OsList(this, columnKey);
    }

    @Override
    public void setLong(long columnKey, long value) {
        this.parent.checkImmutable();
        this.nativeSetLong(this.nativePtr, columnKey, value);
    }

    @Override
    public void setBoolean(long columnKey, boolean value) {
        this.parent.checkImmutable();
        this.nativeSetBoolean(this.nativePtr, columnKey, value);
    }

    @Override
    public void setFloat(long columnKey, float value) {
        this.parent.checkImmutable();
        this.nativeSetFloat(this.nativePtr, columnKey, value);
    }

    @Override
    public void setDouble(long columnKey, double value) {
        this.parent.checkImmutable();
        this.nativeSetDouble(this.nativePtr, columnKey, value);
    }

    @Override
    public void setDate(long columnKey, Date date) {
        this.parent.checkImmutable();
        if (date == null) {
            throw new IllegalArgumentException("Null Date is not allowed.");
        }
        long timestamp = date.getTime();
        this.nativeSetTimestamp(this.nativePtr, columnKey, timestamp);
    }

    @Override
    public void setString(long columnKey, @Nullable String value) {
        this.parent.checkImmutable();
        if (value == null) {
            this.nativeSetNull(this.nativePtr, columnKey);
        } else {
            this.nativeSetString(this.nativePtr, columnKey, value);
        }
    }

    @Override
    public void setBinaryByteArray(long columnKey, @Nullable byte[] data) {
        this.parent.checkImmutable();
        this.nativeSetByteArray(this.nativePtr, columnKey, data);
    }

    @Override
    public void setLink(long columnKey, long value) {
        this.parent.checkImmutable();
        this.nativeSetLink(this.nativePtr, columnKey, value);
    }

    @Override
    public void nullifyLink(long columnKey) {
        this.parent.checkImmutable();
        this.nativeNullifyLink(this.nativePtr, columnKey);
    }

    @Override
    public boolean isNull(long columnKey) {
        return this.nativeIsNull(this.nativePtr, columnKey);
    }

    @Override
    public void setNull(long columnKey) {
        this.parent.checkImmutable();
        this.nativeSetNull(this.nativePtr, columnKey);
    }

    @Override
    public void setDecimal128(long columnKey, @Nullable Decimal128 value) {
        this.parent.checkImmutable();
        if (value == null) {
            this.nativeSetNull(this.nativePtr, columnKey);
        } else {
            this.nativeSetDecimal128(this.nativePtr, columnKey, value.getLow(), value.getHigh());
        }
    }

    @Override
    public void setObjectId(long columnKey, @Nullable ObjectId value) {
        this.parent.checkImmutable();
        if (value == null) {
            this.nativeSetNull(this.nativePtr, columnKey);
        } else {
            this.nativeSetObjectId(this.nativePtr, columnKey, value.toString());
        }
    }

    @Override
    public long createEmbeddedObject(long columnKey, RealmFieldType parentPropertyType) {
        switch (parentPropertyType) {
            case OBJECT: {
                this.parent.checkImmutable();
                return this.nativeCreateEmbeddedObject(this.nativePtr, columnKey);
            }
            case LIST: {
                return this.getModelList(columnKey).createAndAddEmbeddedObject();
            }
        }
        throw new IllegalArgumentException("Wrong parentPropertyType, expected OBJECT or LIST but received " + (Object)((Object)parentPropertyType));
    }

    public CheckedRow convertToChecked() {
        return CheckedRow.getFromRow(this);
    }

    @Override
    public boolean isValid() {
        return this.nativePtr != 0L && this.nativeIsValid(this.nativePtr);
    }

    @Override
    public void checkIfAttached() {
        if (!this.isValid()) {
            throw new IllegalStateException("Object is no longer managed by Realm. Has it been deleted?");
        }
    }

    @Override
    public boolean hasColumn(String fieldName) {
        return this.nativeHasColumn(this.nativePtr, fieldName);
    }

    @Override
    public Row freeze(OsSharedRealm frozenRealm) {
        if (!this.isValid()) {
            return InvalidRow.INSTANCE;
        }
        return new UncheckedRow(this.context, this.parent.freeze(frozenRealm), this.nativeFreeze(this.nativePtr, frozenRealm.getNativePtr()));
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    protected native long nativeGetColumnCount(long var1);

    protected native long nativeGetColumnKey(long var1, String var3);

    protected native String[] nativeGetColumnNames(long var1);

    protected native int nativeGetColumnType(long var1, long var3);

    protected native long nativeGetObjectKey(long var1);

    protected native long nativeGetLong(long var1, long var3);

    protected native boolean nativeGetBoolean(long var1, long var3);

    protected native float nativeGetFloat(long var1, long var3);

    protected native double nativeGetDouble(long var1, long var3);

    protected native long nativeGetTimestamp(long var1, long var3);

    protected native String nativeGetString(long var1, long var3);

    protected native boolean nativeIsNullLink(long var1, long var3);

    protected native byte[] nativeGetByteArray(long var1, long var3);

    protected native long[] nativeGetDecimal128(long var1, long var3);

    protected native String nativeGetObjectId(long var1, long var3);

    protected native void nativeSetLong(long var1, long var3, long var5);

    protected native void nativeSetBoolean(long var1, long var3, boolean var5);

    protected native void nativeSetFloat(long var1, long var3, float var5);

    protected native long nativeGetLink(long var1, long var3);

    protected native void nativeSetDouble(long var1, long var3, double var5);

    protected native void nativeSetTimestamp(long var1, long var3, long var5);

    protected native void nativeSetString(long var1, long var3, String var5);

    protected native void nativeSetByteArray(long var1, long var3, @Nullable byte[] var5);

    protected native void nativeSetDecimal128(long var1, long var3, long var5, long var7);

    protected native void nativeSetObjectId(long var1, long var3, String var5);

    protected native void nativeSetLink(long var1, long var3, long var5);

    protected native void nativeNullifyLink(long var1, long var3);

    protected native boolean nativeIsValid(long var1);

    protected native boolean nativeHasColumn(long var1, String var3);

    protected native boolean nativeIsNull(long var1, long var3);

    protected native void nativeSetNull(long var1, long var3);

    protected native long nativeFreeze(long var1, long var3);

    protected native long nativeCreateEmbeddedObject(long var1, long var3);

    private static native long nativeGetFinalizerPtr();
}

