/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.MapValueOperator;
import io.realm.RealmAny;
import io.realm.RealmAnyOperator;
import io.realm.RealmMapEntrySet;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.core.NativeRealmAny;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class RealmAnyValueOperator<K>
extends MapValueOperator<K, RealmAny> {
    RealmAnyValueOperator(BaseRealm baseRealm, OsMap osMap, TypeSelectorForMap<K, RealmAny> typeSelectorForMap) {
        super(RealmAny.class, baseRealm, osMap, typeSelectorForMap, RealmMapEntrySet.IteratorType.MIXED);
    }

    @Override
    @Nullable
    RealmAny get(Object key) {
        long realmAnyPtr = this.osMap.getRealmAnyPtr(key);
        if (realmAnyPtr == -1L) {
            return null;
        }
        NativeRealmAny nativeRealmAny = new NativeRealmAny(realmAnyPtr);
        return new RealmAny(RealmAnyOperator.fromNativeRealmAny(this.baseRealm, nativeRealmAny));
    }

    @Override
    @Nullable
    RealmAny put(Object key, @Nullable RealmAny value) {
        RealmAny original = this.get(key);
        if (value == null) {
            this.osMap.put(key, null);
        } else {
            this.osMap.putRealmAny(key, CollectionUtils.copyToRealmIfNeeded(this.baseRealm, value).getNativePtr());
        }
        return original;
    }

    @Override
    Set<Map.Entry<K, RealmAny>> entrySet() {
        return new RealmMapEntrySet(this.baseRealm, this.osMap, RealmMapEntrySet.IteratorType.MIXED, null);
    }

    @Override
    boolean containsValueInternal(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof RealmAny) {
            return this.osMap.containsRealmAnyValue(((RealmAny)value).getNativePtr());
        }
        throw new IllegalArgumentException("This dictionary can only contain 'RealmAny' values.");
    }
}

