/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.ImportFlag;
import io.realm.Realm;
import io.realm.RealmAny;
import io.realm.RealmModel;
import io.realm.internal.OsObjectStore;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;

public class CollectionUtils {
    public static final String LIST_TYPE = "list";
    public static final String DICTIONARY_TYPE = "dictionary";
    public static final String SET_TYPE = "set";

    static boolean isClassForRealmModel(Class<?> clazz) {
        return RealmModel.class.isAssignableFrom(clazz);
    }

    static boolean isEmbedded(BaseRealm realm, RealmModel object) {
        if (realm instanceof Realm) {
            return realm.getSchema().getSchemaForClass(object.getClass()).isEmbedded();
        }
        String objectType = ((DynamicRealmObject)object).getType();
        return realm.getSchema().getSchemaForClass(objectType).isEmbedded();
    }

    static boolean checkCanObjectBeCopied(BaseRealm realm, RealmModel object, String className, String collectionType) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            if (proxy instanceof DynamicRealmObject) {
                if (proxy.realmGet$proxyState().getRealm$realm() == realm) {
                    String objectClassName = ((DynamicRealmObject)object).getType();
                    if (className.equals(RealmAny.class.getCanonicalName()) || className.equals(objectClassName)) {
                        return false;
                    }
                    throw new IllegalArgumentException(String.format(Locale.US, "The object has a different type from %s's. Type of the %s is '%s', type of object is '%s'.", collectionType, collectionType, className, objectClassName));
                }
                if (realm.threadId == proxy.realmGet$proxyState().getRealm$realm().threadId) {
                    throw new IllegalArgumentException("Cannot pass DynamicRealmObject between Realm instances.");
                }
                throw new IllegalStateException("Cannot pass an object to a Realm instance created in another thread.");
            }
            if (proxy.realmGet$proxyState().getRow$realm() != null && proxy.realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                if (realm != proxy.realmGet$proxyState().getRealm$realm()) {
                    throw new IllegalArgumentException("Cannot pass an object from another Realm instance.");
                }
                return false;
            }
        }
        return true;
    }

    static RealmAny copyToRealmIfNeeded(BaseRealm realm, RealmAny realmAny) {
        if (realmAny.getType() == RealmAny.Type.OBJECT) {
            Class<?> objectClass = realmAny.getValueClass();
            Object object = realmAny.asRealmModel(objectClass);
            if (object instanceof RealmObjectProxy) {
                RealmObjectProxy proxy = (RealmObjectProxy)object;
                if (proxy instanceof DynamicRealmObject) {
                    if (proxy.realmGet$proxyState().getRealm$realm() == realm) {
                        return realmAny;
                    }
                    if (realm.threadId == proxy.realmGet$proxyState().getRealm$realm().threadId) {
                        throw new IllegalArgumentException("Cannot copy DynamicRealmObject between Realm instances.");
                    }
                    throw new IllegalStateException("Cannot copy an object to a Realm instance created in another thread.");
                }
                if (realm.getSchema().getSchemaForClass(objectClass).isEmbedded()) {
                    throw new IllegalArgumentException("Embedded objects are not supported by RealmAny.");
                }
                if (proxy.realmGet$proxyState().getRow$realm() != null && proxy.realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                    if (realm != proxy.realmGet$proxyState().getRealm$realm()) {
                        throw new IllegalArgumentException("Cannot copy an object from another Realm instance.");
                    }
                    return realmAny;
                }
            }
            return RealmAny.valueOf(CollectionUtils.copyToRealm(realm, object));
        }
        return realmAny;
    }

    public static <E extends RealmModel> E copyToRealm(BaseRealm baseRealm, E object) {
        Realm realm = (Realm)baseRealm;
        String simpleClassName = realm.getConfiguration().getSchemaMediator().getSimpleClassName(object.getClass());
        if (OsObjectStore.getPrimaryKeyForObject(realm.getSharedRealm(), simpleClassName) != null) {
            return realm.copyToRealmOrUpdate(object, new ImportFlag[0]);
        }
        return realm.copyToRealm(object, new ImportFlag[0]);
    }

    public static void checkForAddRemoveListener(BaseRealm baseRealm, @Nullable Object listener2, boolean checkListener) {
        if (checkListener && listener2 == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        baseRealm.checkIfValid();
        baseRealm.sharedRealm.capabilities.checkCanDeliverNotification("Listeners cannot be used on current thread.");
    }

    static void updateEmbeddedObject(Realm realm, RealmModel realmModel, long objKey) {
        RealmProxyMediator schemaMediator = realm.getConfiguration().getSchemaMediator();
        Class<? extends RealmModel> modelClass = Util.getOriginalModelClass(realmModel.getClass());
        Table table = realm.getTable(modelClass);
        RealmModel managedObject = schemaMediator.newInstance(modelClass, realm, table.getUncheckedRow(objKey), realm.getSchema().getColumnInfo(modelClass), true, Collections.EMPTY_LIST);
        schemaMediator.updateEmbeddedObject(realm, realmModel, managedObject, new HashMap<RealmModel, RealmObjectProxy>(), Collections.EMPTY_SET);
    }
}

