/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.MapChangeListener;
import io.realm.MapChangeSet;
import io.realm.MapChangeSetImpl;
import io.realm.MapValueOperator;
import io.realm.RealmChangeListener;
import io.realm.RealmMap;
import io.realm.TypeSelectorForMap;
import io.realm.internal.Freezable;
import io.realm.internal.ManageableObject;
import io.realm.internal.ObservableMap;
import io.realm.internal.ObserverPairList;
import io.realm.internal.OsMap;
import io.realm.internal.util.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class ManagedMapManager<K, V>
implements Map<K, V>,
ManageableObject,
Freezable<RealmMap<K, V>>,
ObservableMap {
    protected final BaseRealm baseRealm;
    protected final MapValueOperator<K, V> mapValueOperator;
    protected final TypeSelectorForMap<K, V> typeSelectorForMap;
    protected final ObserverPairList<ObservableMap.MapObserverPair<K, V>> mapObserverPairs = new ObserverPairList();

    ManagedMapManager(BaseRealm baseRealm, MapValueOperator<K, V> mapValueOperator, TypeSelectorForMap<K, V> typeSelectorForMap) {
        this.baseRealm = baseRealm;
        this.mapValueOperator = mapValueOperator;
        this.typeSelectorForMap = typeSelectorForMap;
    }

    abstract boolean containsKeyInternal(@Nullable Object var1);

    abstract void validateMap(Map<? extends K, ? extends V> var1);

    abstract RealmMap<K, V> freezeInternal(Pair<BaseRealm, OsMap> var1);

    abstract MapChangeSet<K> changeSetFactory(long var1);

    @Override
    public abstract V put(@Nullable K var1, @Nullable V var2);

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.mapValueOperator.isValid();
    }

    @Override
    public boolean isFrozen() {
        return this.mapValueOperator.isFrozen();
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed.");
        }
        V removedValue = this.mapValueOperator.get(key);
        this.mapValueOperator.remove(key);
        return removedValue;
    }

    @Override
    public int size() {
        return this.mapValueOperator.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapValueOperator.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.containsKeyInternal(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.mapValueOperator.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.validateMap(m);
        this.mapValueOperator.putAll(m);
    }

    @Override
    public void clear() {
        this.mapValueOperator.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.mapValueOperator.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.mapValueOperator.values();
    }

    @Override
    public RealmMap<K, V> freeze() {
        return this.freezeInternal(this.mapValueOperator.freeze());
    }

    @Override
    public void notifyChangeListeners(long nativeChangeSetPtr) {
        MapChangeSetImpl<K> mapChangeSet = new MapChangeSetImpl<K>(this.changeSetFactory(nativeChangeSetPtr));
        if (mapChangeSet.isEmpty()) {
            return;
        }
        this.mapObserverPairs.foreach(new ObservableMap.Callback(mapChangeSet));
    }

    void addChangeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener2) {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, listener2, true);
        if (this.mapObserverPairs.isEmpty()) {
            this.mapValueOperator.startListening(this);
        }
        ObservableMap.MapObserverPair<K, V> mapObserverPair = new ObservableMap.MapObserverPair<K, V>(realmMap, listener2);
        this.mapObserverPairs.add(mapObserverPair);
    }

    void addChangeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener2) {
        this.addChangeListener(realmMap, new ObservableMap.RealmChangeListenerWrapper<K, V>(listener2));
    }

    void removeListener(RealmMap<K, V> realmMap, MapChangeListener<K, V> listener2) {
        this.mapObserverPairs.remove(realmMap, listener2);
        if (this.mapObserverPairs.isEmpty()) {
            this.mapValueOperator.stopListening();
        }
    }

    void removeListener(RealmMap<K, V> realmMap, RealmChangeListener<RealmMap<K, V>> listener2) {
        this.removeListener(realmMap, new ObservableMap.RealmChangeListenerWrapper<K, V>(listener2));
    }

    void removeAllChangeListeners() {
        CollectionUtils.checkForAddRemoveListener(this.baseRealm, null, false);
        this.mapObserverPairs.clear();
        this.mapValueOperator.stopListening();
    }

    boolean hasListeners() {
        return !this.mapObserverPairs.isEmpty();
    }

    boolean isNotNullItemTypeValid(@Nullable Object item, Class<?> clazz) {
        return item == null || item.getClass() == clazz;
    }

    OsMap getOsMap() {
        return this.mapValueOperator.osMap;
    }

    String getClassName() {
        return this.typeSelectorForMap.getValueClassName();
    }

    Class<V> getValueClass() {
        return this.typeSelectorForMap.getValueClass();
    }
}

