/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealm;
import io.realm.Realm;
import io.realm.RealmAsyncTask;
import io.realm.RealmConfiguration;
import io.realm.RealmMigration;
import io.realm.exceptions.RealmFileException;
import io.realm.internal.ObjectServerFacade;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmNotifier;
import io.realm.internal.Util;
import io.realm.internal.android.AndroidCapabilities;
import io.realm.internal.android.AndroidRealmNotifier;
import io.realm.internal.async.RealmAsyncTaskImpl;
import io.realm.internal.util.Pair;
import io.realm.log.RealmLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

final class RealmCache {
    private static final String ASYNC_NOT_ALLOWED_MSG = "Realm instances cannot be loaded asynchronously on a non-looper thread.";
    private static final String ASYNC_CALLBACK_NULL_MSG = "The callback cannot be null.";
    private final Map<Pair<RealmCacheType, OsSharedRealm.VersionID>, ReferenceCounter> refAndCountMap = new HashMap<Pair<RealmCacheType, OsSharedRealm.VersionID>, ReferenceCounter>();
    private final String realmPath;
    private RealmConfiguration configuration;
    private static final List<WeakReference<RealmCache>> cachesList = new ArrayList<WeakReference<RealmCache>>();
    private final AtomicBoolean isLeaked = new AtomicBoolean(false);
    private static final Collection<RealmCache> leakedCaches = new ConcurrentLinkedQueue<RealmCache>();
    private final Set<String> pendingRealmFileCreation = new HashSet<String>();
    private static final String DIFFERENT_KEY_MESSAGE = "Wrong key used to decrypt Realm.";
    private static final String WRONG_REALM_CLASS_MESSAGE = "The type of Realm class must be Realm or DynamicRealm.";

    private RealmCache(String path) {
        this.realmPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RealmCache getCache(String realmPath, boolean createIfNotExist) {
        RealmCache cacheToReturn = null;
        List<WeakReference<RealmCache>> list = cachesList;
        synchronized (list) {
            Iterator<WeakReference<RealmCache>> it = cachesList.iterator();
            while (it.hasNext()) {
                RealmCache cache = (RealmCache)it.next().get();
                if (cache == null) {
                    it.remove();
                    continue;
                }
                if (!cache.realmPath.equals(realmPath)) continue;
                cacheToReturn = cache;
            }
            if (cacheToReturn == null && createIfNotExist) {
                cacheToReturn = new RealmCache(realmPath);
                cachesList.add(new WeakReference<RealmCache>(cacheToReturn));
            }
        }
        return cacheToReturn;
    }

    static <T extends BaseRealm> RealmAsyncTask createRealmOrGetFromCacheAsync(RealmConfiguration configuration, BaseRealm.InstanceCallback<T> callback, Class<T> realmClass) {
        RealmCache cache = RealmCache.getCache(configuration.getPath(), true);
        return cache.doCreateRealmOrGetFromCacheAsync(configuration, callback, realmClass);
    }

    private synchronized <T extends BaseRealm> RealmAsyncTask doCreateRealmOrGetFromCacheAsync(RealmConfiguration configuration, BaseRealm.InstanceCallback<T> callback, Class<T> realmClass) {
        AndroidCapabilities capabilities = new AndroidCapabilities();
        capabilities.checkCanDeliverNotification(ASYNC_NOT_ALLOWED_MSG);
        if (callback == null) {
            throw new IllegalArgumentException(ASYNC_CALLBACK_NULL_MSG);
        }
        if (configuration.isSyncConfiguration() && !configuration.realmExists()) {
            this.pendingRealmFileCreation.add(configuration.getPath());
        }
        CreateRealmRunnable<T> createRealmRunnable = new CreateRealmRunnable<T>(new AndroidRealmNotifier(null, capabilities), configuration, callback, realmClass);
        Future<?> future = BaseRealm.asyncTaskExecutor.submitTransaction(createRealmRunnable);
        createRealmRunnable.setFuture(future);
        ObjectServerFacade.getSyncFacadeIfPossible().createNativeSyncSession(configuration);
        return new RealmAsyncTaskImpl(future, BaseRealm.asyncTaskExecutor);
    }

    static <E extends BaseRealm> E createRealmOrGetFromCache(RealmConfiguration configuration, Class<E> realmClass) {
        RealmCache cache = RealmCache.getCache(configuration.getPath(), true);
        return cache.doCreateRealmOrGetFromCache(configuration, realmClass, OsSharedRealm.VersionID.LIVE);
    }

    static <E extends BaseRealm> E createRealmOrGetFromCache(RealmConfiguration configuration, Class<E> realmClass, OsSharedRealm.VersionID version) {
        RealmCache cache = RealmCache.getCache(configuration.getPath(), true);
        return cache.doCreateRealmOrGetFromCache(configuration, realmClass, version);
    }

    private synchronized <E extends BaseRealm> E doCreateRealmOrGetFromCache(RealmConfiguration configuration, Class<E> realmClass, OsSharedRealm.VersionID version) {
        boolean firstRealmInstanceInProcess;
        ReferenceCounter referenceCounter = this.getRefCounter(realmClass, version);
        boolean bl = firstRealmInstanceInProcess = this.getTotalGlobalRefCount() == 0;
        if (firstRealmInstanceInProcess) {
            boolean realmFileIsBeingCreated;
            RealmCache.copyAssetFileIfNeeded(configuration);
            boolean bl2 = realmFileIsBeingCreated = !configuration.realmExists();
            if (configuration.isSyncConfiguration() && (realmFileIsBeingCreated || this.pendingRealmFileCreation.contains(configuration.getPath()))) {
                OsRealmConfig osConfig = new OsRealmConfig.Builder(configuration).build();
                ObjectServerFacade.getSyncFacadeIfPossible().wrapObjectStoreSessionIfRequired(osConfig);
                ObjectServerFacade.getSyncFacadeIfPossible().downloadInitialRemoteChanges(configuration);
                this.pendingRealmFileCreation.remove(configuration.getPath());
            }
            this.configuration = configuration;
        } else {
            this.validateConfiguration(configuration);
        }
        if (!referenceCounter.hasInstanceAvailableForThread()) {
            this.createInstance(realmClass, referenceCounter, version);
        }
        referenceCounter.incrementThreadCount(1);
        return (E)referenceCounter.getRealmInstance();
    }

    private <E extends BaseRealm> ReferenceCounter getRefCounter(Class<E> realmClass, OsSharedRealm.VersionID version) {
        RealmCacheType cacheType = RealmCacheType.valueOf(realmClass);
        Pair<RealmCacheType, OsSharedRealm.VersionID> key = new Pair<RealmCacheType, OsSharedRealm.VersionID>(cacheType, version);
        ReferenceCounter refCounter = this.refAndCountMap.get(key);
        if (refCounter == null) {
            refCounter = version.equals(OsSharedRealm.VersionID.LIVE) ? new ThreadConfinedReferenceCounter() : new GlobalReferenceCounter();
            this.refAndCountMap.put(key, refCounter);
        }
        return refCounter;
    }

    private <E extends BaseRealm> void createInstance(Class<E> realmClass, ReferenceCounter referenceCounter, OsSharedRealm.VersionID version) {
        BaseRealm realm;
        if (realmClass == Realm.class) {
            realm = Realm.createInstance(this, version);
            ((BaseRealm)realm).getSchema().createKeyPathMapping();
        } else if (realmClass == DynamicRealm.class) {
            realm = DynamicRealm.createInstance(this, version);
        } else {
            throw new IllegalArgumentException(WRONG_REALM_CLASS_MESSAGE);
        }
        referenceCounter.onRealmCreated(realm);
    }

    synchronized void release(BaseRealm realm) {
        String canonicalPath = realm.getPath();
        ReferenceCounter referenceCounter = this.getRefCounter(realm.getClass(), realm.isFrozen() ? realm.sharedRealm.getVersionID() : OsSharedRealm.VersionID.LIVE);
        int refCount = referenceCounter.getThreadLocalCount();
        if (refCount <= 0) {
            RealmLog.warn("%s has been closed already. refCount is %s", canonicalPath, refCount);
            return;
        }
        if (--refCount == 0) {
            referenceCounter.clearThreadLocalCache();
            realm.doClose();
            if (this.getTotalLiveRealmGlobalRefCount() == 0) {
                this.configuration = null;
                for (ReferenceCounter counter : this.refAndCountMap.values()) {
                    BaseRealm cachedRealm;
                    if (!(counter instanceof GlobalReferenceCounter) || (cachedRealm = counter.getRealmInstance()) == null) continue;
                    while (!cachedRealm.isClosed()) {
                        cachedRealm.close();
                    }
                }
                ObjectServerFacade.getFacade(realm.getConfiguration().isSyncConfiguration()).realmClosed(realm.getConfiguration());
            }
        } else {
            referenceCounter.setThreadCount(refCount);
        }
    }

    private void validateConfiguration(RealmConfiguration newConfiguration) {
        if (this.configuration.equals(newConfiguration)) {
            return;
        }
        if (!Arrays.equals(this.configuration.getEncryptionKey(), newConfiguration.getEncryptionKey())) {
            throw new IllegalArgumentException(DIFFERENT_KEY_MESSAGE);
        }
        RealmMigration newMigration = newConfiguration.getMigration();
        RealmMigration oldMigration = this.configuration.getMigration();
        if (oldMigration != null && newMigration != null && oldMigration.getClass().equals(newMigration.getClass()) && !newMigration.equals(oldMigration)) {
            throw new IllegalArgumentException("Configurations cannot be different if used to open the same file. The most likely cause is that equals() and hashCode() are not overridden in the migration class: " + newConfiguration.getMigration().getClass().getCanonicalName());
        }
        throw new IllegalArgumentException("Configurations cannot be different if used to open the same file. \nCached configuration: \n" + this.configuration + "\n\nNew configuration: \n" + newConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invokeWithGlobalRefCount(RealmConfiguration configuration, Callback callback) {
        List<WeakReference<RealmCache>> list = cachesList;
        synchronized (list) {
            RealmCache cache = RealmCache.getCache(configuration.getPath(), false);
            if (cache == null) {
                callback.onResult(0);
                return;
            }
            cache.doInvokeWithGlobalRefCount(callback);
        }
    }

    private synchronized void doInvokeWithGlobalRefCount(Callback callback) {
        callback.onResult(this.getTotalGlobalRefCount());
    }

    synchronized void invokeWithLock(Callback0 callback) {
        callback.onCall();
    }

    private static void copyAssetFileIfNeeded(final RealmConfiguration configuration) {
        boolean certFileExists;
        final File realmFileFromAsset = configuration.hasAssetFile() ? new File(configuration.getRealmDirectory(), configuration.getRealmFileName()) : null;
        final String syncServerCertificateAssetName = ObjectServerFacade.getFacade(configuration.isSyncConfiguration()).getSyncServerCertificateAssetName(configuration);
        boolean bl = certFileExists = !Util.isEmptyString(syncServerCertificateAssetName);
        if (realmFileFromAsset != null || certFileExists) {
            OsObjectStore.callWithLock(configuration, new Runnable(){

                @Override
                public void run() {
                    if (realmFileFromAsset != null) {
                        RealmCache.copyFileIfNeeded(configuration.getAssetFilePath(), realmFileFromAsset);
                    }
                    if (certFileExists) {
                        String syncServerCertificateFilePath = ObjectServerFacade.getFacade(configuration.isSyncConfiguration()).getSyncServerCertificateFilePath(configuration);
                        File certificateFile = new File(syncServerCertificateFilePath);
                        RealmCache.copyFileIfNeeded(syncServerCertificateAssetName, certificateFile);
                    }
                }
            });
        }
    }

    private static void copyFileIfNeeded(String assetFileName, File file) {
        if (file.exists()) {
            return;
        }
        IOException exceptionWhenClose = null;
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = BaseRealm.applicationContext.getAssets().open(assetFileName);
            if (inputStream == null) {
                throw new RealmFileException(RealmFileException.Kind.ACCESS_ERROR, "Invalid input stream to the asset file: " + assetFileName);
            }
            outputStream = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((bytesRead = inputStream.read(buf)) > -1) {
                outputStream.write(buf, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new RealmFileException(RealmFileException.Kind.ACCESS_ERROR, "Could not resolve the path to the asset file: " + assetFileName, e);
        }
        finally {
            block20: {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        exceptionWhenClose = e;
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        if (exceptionWhenClose != null) break block20;
                        exceptionWhenClose = e;
                    }
                }
            }
        }
        if (exceptionWhenClose != null) {
            throw new RealmFileException(RealmFileException.Kind.ACCESS_ERROR, (Throwable)exceptionWhenClose);
        }
    }

    static int getLocalThreadCount(RealmConfiguration configuration) {
        RealmCache cache = RealmCache.getCache(configuration.getPath(), false);
        if (cache == null) {
            return 0;
        }
        int totalRefCount = 0;
        for (ReferenceCounter referenceCounter : cache.refAndCountMap.values()) {
            totalRefCount += referenceCounter.getThreadLocalCount();
        }
        return totalRefCount;
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    private int getTotalGlobalRefCount() {
        int totalRefCount = 0;
        for (ReferenceCounter referenceCounter : this.refAndCountMap.values()) {
            totalRefCount += referenceCounter.getGlobalCount();
        }
        return totalRefCount;
    }

    private int getTotalLiveRealmGlobalRefCount() {
        int totalRefCount = 0;
        for (ReferenceCounter referenceCounter : this.refAndCountMap.values()) {
            if (!(referenceCounter instanceof ThreadConfinedReferenceCounter)) continue;
            totalRefCount += referenceCounter.getGlobalCount();
        }
        return totalRefCount;
    }

    void leak() {
        if (!this.isLeaked.getAndSet(true)) {
            leakedCaches.add(this);
        }
    }

    private static class CreateRealmRunnable<T extends BaseRealm>
    implements Runnable {
        private final RealmConfiguration configuration;
        private final BaseRealm.InstanceCallback<T> callback;
        private final Class<T> realmClass;
        private final CountDownLatch canReleaseBackgroundInstanceLatch = new CountDownLatch(1);
        private final RealmNotifier notifier;
        private Future future;

        CreateRealmRunnable(RealmNotifier notifier, RealmConfiguration configuration, BaseRealm.InstanceCallback<T> callback, Class<T> realmClass) {
            this.configuration = configuration;
            this.realmClass = realmClass;
            this.callback = callback;
            this.notifier = notifier;
        }

        public void setFuture(Future future) {
            this.future = future;
        }

        @Override
        public void run() {
            try (BaseRealm instance = null;){
                instance = (BaseRealm)RealmCache.createRealmOrGetFromCache(this.configuration, this.realmClass);
                boolean results = this.notifier.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (future == null || future.isCancelled()) {
                            canReleaseBackgroundInstanceLatch.countDown();
                            return;
                        }
                        Object instanceToReturn = null;
                        Throwable throwable = null;
                        try {
                            instanceToReturn = RealmCache.createRealmOrGetFromCache(configuration, realmClass);
                        }
                        catch (Throwable e) {
                            throwable = e;
                        }
                        finally {
                            canReleaseBackgroundInstanceLatch.countDown();
                        }
                        if (instanceToReturn != null) {
                            callback.onSuccess(instanceToReturn);
                        } else {
                            callback.onError(throwable);
                        }
                    }
                });
                if (!results) {
                    this.canReleaseBackgroundInstanceLatch.countDown();
                }
                if (!this.canReleaseBackgroundInstanceLatch.await(2L, TimeUnit.SECONDS)) {
                    RealmLog.warn("Timeout for creating Realm instance in foreground thread in `CreateRealmRunnable` ", new Object[0]);
                }
            }
        }
    }

    private static enum RealmCacheType {
        TYPED_REALM,
        DYNAMIC_REALM;


        static RealmCacheType valueOf(Class<? extends BaseRealm> clazz) {
            if (clazz == Realm.class) {
                return TYPED_REALM;
            }
            if (clazz == DynamicRealm.class) {
                return DYNAMIC_REALM;
            }
            throw new IllegalArgumentException(RealmCache.WRONG_REALM_CLASS_MESSAGE);
        }
    }

    private static class ThreadConfinedReferenceCounter
    extends ReferenceCounter {
        private final ThreadLocal<BaseRealm> localRealm = new ThreadLocal();

        private ThreadConfinedReferenceCounter() {
        }

        @Override
        public boolean hasInstanceAvailableForThread() {
            return this.localRealm.get() != null;
        }

        @Override
        public BaseRealm getRealmInstance() {
            return this.localRealm.get();
        }

        @Override
        public void onRealmCreated(BaseRealm realm) {
            this.localRealm.set(realm);
            this.localCount.set(0);
            this.globalCount.incrementAndGet();
        }

        @Override
        public void clearThreadLocalCache() {
            String canonicalPath = this.localRealm.get().getPath();
            this.localCount.set(null);
            this.localRealm.set(null);
            if (this.globalCount.decrementAndGet() < 0) {
                throw new IllegalStateException("Global reference counter of Realm" + canonicalPath + " can not be negative.");
            }
        }

        @Override
        public int getThreadLocalCount() {
            Integer refCount = (Integer)this.localCount.get();
            return refCount != null ? refCount : 0;
        }
    }

    private static class GlobalReferenceCounter
    extends ReferenceCounter {
        private BaseRealm cachedRealm;

        private GlobalReferenceCounter() {
        }

        @Override
        boolean hasInstanceAvailableForThread() {
            return this.cachedRealm != null;
        }

        @Override
        BaseRealm getRealmInstance() {
            return this.cachedRealm;
        }

        @Override
        void onRealmCreated(BaseRealm realm) {
            this.cachedRealm = realm;
            this.localCount.set(0);
            this.globalCount.incrementAndGet();
        }

        @Override
        public void clearThreadLocalCache() {
            String canonicalPath = this.cachedRealm.getPath();
            this.localCount.set(null);
            this.cachedRealm = null;
            if (this.globalCount.decrementAndGet() < 0) {
                throw new IllegalStateException("Global reference counter of Realm" + canonicalPath + " not be negative.");
            }
        }

        @Override
        int getThreadLocalCount() {
            return this.globalCount.get();
        }
    }

    private static abstract class ReferenceCounter {
        protected final ThreadLocal<Integer> localCount = new ThreadLocal();
        protected AtomicInteger globalCount = new AtomicInteger(0);

        private ReferenceCounter() {
        }

        abstract boolean hasInstanceAvailableForThread();

        public void incrementThreadCount(int increment) {
            Integer currentCount = this.localCount.get();
            this.localCount.set(currentCount != null ? currentCount + increment : increment);
        }

        abstract BaseRealm getRealmInstance();

        abstract void onRealmCreated(BaseRealm var1);

        abstract void clearThreadLocalCache();

        abstract int getThreadLocalCount();

        public void setThreadCount(int refCount) {
            this.localCount.set(refCount);
        }

        public int getGlobalCount() {
            return this.globalCount.get();
        }
    }

    static interface Callback0 {
        public void onCall();
    }

    static interface Callback {
        public void onResult(int var1);
    }
}

