/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmFieldType;
import io.realm.internal.OsObjectSchemaInfo;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.Property;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ColumnInfo {
    private final Map<String, ColumnDetails> columnkeysFromJavaFieldNames;
    private final Map<String, ColumnDetails> columnKeysFromColumnNames;
    private final Map<String, String> javaFieldNameToInternalNames;
    private final boolean mutable;

    protected ColumnInfo(int mapSize) {
        this(mapSize, true);
    }

    protected ColumnInfo(@Nullable ColumnInfo src, boolean mutable) {
        this(src == null ? 0 : src.columnkeysFromJavaFieldNames.size(), mutable);
        if (src != null) {
            this.columnkeysFromJavaFieldNames.putAll(src.columnkeysFromJavaFieldNames);
        }
    }

    private ColumnInfo(int mapSize, boolean mutable) {
        this.columnkeysFromJavaFieldNames = new HashMap<String, ColumnDetails>(mapSize);
        this.columnKeysFromColumnNames = new HashMap<String, ColumnDetails>(mapSize);
        this.javaFieldNameToInternalNames = new HashMap<String, String>(mapSize);
        this.mutable = mutable;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public long getColumnKey(String javaFieldName) {
        ColumnDetails details = this.columnkeysFromJavaFieldNames.get(javaFieldName);
        return details == null ? -1L : details.columnKey;
    }

    @Nullable
    public ColumnDetails getColumnDetails(String javaFieldName) {
        return this.columnkeysFromJavaFieldNames.get(javaFieldName);
    }

    @Nullable
    public String getInternalFieldName(String javaFieldName) {
        return this.javaFieldNameToInternalNames.get(javaFieldName);
    }

    public void copyFrom(ColumnInfo src) {
        if (!this.mutable) {
            throw new UnsupportedOperationException("Attempt to modify an immutable ColumnInfo");
        }
        if (null == src) {
            throw new NullPointerException("Attempt to copy null ColumnInfo");
        }
        this.columnkeysFromJavaFieldNames.clear();
        this.columnkeysFromJavaFieldNames.putAll(src.columnkeysFromJavaFieldNames);
        this.columnKeysFromColumnNames.clear();
        this.columnKeysFromColumnNames.putAll(src.columnKeysFromColumnNames);
        this.javaFieldNameToInternalNames.clear();
        this.javaFieldNameToInternalNames.putAll(src.javaFieldNameToInternalNames);
        this.copy(src, this);
    }

    public String toString() {
        boolean commaNeeded;
        StringBuilder buf = new StringBuilder("ColumnInfo[");
        buf.append("mutable=" + this.mutable).append(",");
        if (this.columnkeysFromJavaFieldNames != null) {
            buf.append("JavaFieldNames=[");
            commaNeeded = false;
            for (Map.Entry<String, ColumnDetails> entry : this.columnkeysFromJavaFieldNames.entrySet()) {
                if (commaNeeded) {
                    buf.append(",");
                }
                buf.append(entry.getKey()).append("->").append(entry.getValue());
                commaNeeded = true;
            }
            buf.append("]");
        }
        if (this.columnKeysFromColumnNames != null) {
            buf.append(", InternalFieldNames=[");
            commaNeeded = false;
            for (Map.Entry<String, ColumnDetails> entry : this.columnKeysFromColumnNames.entrySet()) {
                if (commaNeeded) {
                    buf.append(",");
                }
                buf.append(entry.getKey()).append("->").append(entry.getValue());
                commaNeeded = true;
            }
            buf.append("]");
        }
        return buf.append("]").toString();
    }

    protected abstract ColumnInfo copy(boolean var1);

    protected abstract void copy(ColumnInfo var1, ColumnInfo var2);

    protected final long addColumnDetails(String javaFieldName, String internalColumnName, OsObjectSchemaInfo objectSchemaInfo) {
        Property property = objectSchemaInfo.getProperty(internalColumnName);
        ColumnDetails cd = new ColumnDetails(property);
        this.columnkeysFromJavaFieldNames.put(javaFieldName, cd);
        this.columnKeysFromColumnNames.put(internalColumnName, cd);
        this.javaFieldNameToInternalNames.put(javaFieldName, internalColumnName);
        return property.getColumnKey();
    }

    protected final void addBacklinkDetails(OsSchemaInfo schemaInfo, String javaFieldName, String sourceTableName, String sourceJavaFieldName) {
        long columnKey = schemaInfo.getObjectSchemaInfo(sourceTableName).getProperty(sourceJavaFieldName).getColumnKey();
        this.columnkeysFromJavaFieldNames.put(javaFieldName, new ColumnDetails(columnKey, RealmFieldType.LINKING_OBJECTS, sourceTableName));
    }

    public Map<String, ColumnDetails> getColumnKeysMap() {
        return this.columnkeysFromJavaFieldNames;
    }

    public static final class ColumnDetails {
        public final long columnKey;
        public final RealmFieldType columnType;
        public final String linkedClassName;

        private ColumnDetails(long columnKey, RealmFieldType columnType, @Nullable String linkedClassName) {
            this.columnKey = columnKey;
            this.columnType = columnType;
            this.linkedClassName = linkedClassName;
        }

        ColumnDetails(Property property) {
            this(property.getColumnKey(), property.getType(), property.getLinkedObjectName());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("ColumnDetails[");
            buf.append(this.columnKey);
            buf.append(", ").append((Object)this.columnType);
            buf.append(", ").append(this.linkedClassName);
            return buf.append("]").toString();
        }
    }
}

