/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.content.Context;
import android.os.Looper;
import io.reactivex.Flowable;
import io.realm.DynamicRealm;
import io.realm.DynamicRealmObject;
import io.realm.Realm;
import io.realm.RealmCache;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmFieldType;
import io.realm.RealmMigration;
import io.realm.RealmModel;
import io.realm.RealmObjectSchema;
import io.realm.RealmSchema;
import io.realm.exceptions.RealmException;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.CheckedRow;
import io.realm.internal.ColumnInfo;
import io.realm.internal.InvalidRow;
import io.realm.internal.OsObjectStore;
import io.realm.internal.OsRealmConfig;
import io.realm.internal.OsSchemaInfo;
import io.realm.internal.OsSharedRealm;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.Util;
import io.realm.internal.async.RealmThreadPoolExecutor;
import io.realm.log.RealmLog;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

abstract class BaseRealm
implements Closeable {
    private static final String INCORRECT_THREAD_CLOSE_MESSAGE = "Realm access from incorrect thread. Realm instance can only be closed on the thread it was created.";
    static final String INCORRECT_THREAD_MESSAGE = "Realm access from incorrect thread. Realm objects can only be accessed on the thread they were created.";
    static final String CLOSED_REALM_MESSAGE = "This Realm instance has already been closed, making it unusable.";
    private static final String NOT_IN_TRANSACTION_MESSAGE = "Changing Realm data can only be done from inside a transaction.";
    static final String LISTENER_NOT_ALLOWED_MESSAGE = "Listeners cannot be used on current thread.";
    static final String DELETE_NOT_SUPPORTED_UNDER_PARTIAL_SYNC = "This API is not supported by partially synchronized Realms. Either unsubscribe using 'Realm.unsubscribeAsync()' or delete the objects using a query and 'RealmResults.deleteAllFromRealm()'";
    static volatile Context applicationContext;
    static final RealmThreadPoolExecutor asyncTaskExecutor;
    public static final RealmThreadPoolExecutor WRITE_EXECUTOR;
    final boolean frozen;
    final long threadId;
    protected final RealmConfiguration configuration;
    private RealmCache realmCache;
    public OsSharedRealm sharedRealm;
    private boolean shouldCloseSharedRealm;
    private OsSharedRealm.SchemaChangedCallback schemaChangedCallback = new OsSharedRealm.SchemaChangedCallback(){

        @Override
        public void onSchemaChanged() {
            RealmSchema schema = BaseRealm.this.getSchema();
            if (schema != null) {
                schema.refresh();
            }
            if (BaseRealm.this instanceof Realm) {
                schema.createKeyPathMapping();
            }
        }
    };
    public static final ThreadLocalRealmObjectContext objectContext;

    BaseRealm(RealmCache cache, @Nullable OsSchemaInfo schemaInfo, OsSharedRealm.VersionID version) {
        this(cache.getConfiguration(), schemaInfo, version);
        this.realmCache = cache;
    }

    BaseRealm(RealmConfiguration configuration, @Nullable OsSchemaInfo schemaInfo, OsSharedRealm.VersionID version) {
        this.threadId = Thread.currentThread().getId();
        this.configuration = configuration;
        this.realmCache = null;
        OsSharedRealm.MigrationCallback migrationCallback = null;
        if (schemaInfo != null && configuration.getMigration() != null) {
            migrationCallback = BaseRealm.createMigrationCallback(configuration.getMigration());
        }
        OsSharedRealm.InitializationCallback initializationCallback = null;
        final Realm.Transaction initialDataTransaction = configuration.getInitialDataTransaction();
        if (initialDataTransaction != null) {
            initializationCallback = new OsSharedRealm.InitializationCallback(){

                @Override
                public void onInit(OsSharedRealm sharedRealm) {
                    Realm instance = Realm.createInstance(sharedRealm);
                    initialDataTransaction.execute(instance);
                }
            };
        }
        OsRealmConfig.Builder configBuilder = new OsRealmConfig.Builder(configuration).fifoFallbackDir(new File(applicationContext.getFilesDir(), ".realm.temp")).autoUpdateNotification(true).migrationCallback(migrationCallback).schemaInfo(schemaInfo).initializationCallback(initializationCallback);
        this.sharedRealm = OsSharedRealm.getInstance(configBuilder, version);
        this.frozen = this.sharedRealm.isFrozen();
        this.shouldCloseSharedRealm = true;
        this.sharedRealm.registerSchemaChangedCallback(this.schemaChangedCallback);
    }

    BaseRealm(OsSharedRealm sharedRealm) {
        this.threadId = Thread.currentThread().getId();
        this.configuration = sharedRealm.getConfiguration();
        this.realmCache = null;
        this.sharedRealm = sharedRealm;
        this.frozen = sharedRealm.isFrozen();
        this.shouldCloseSharedRealm = false;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.checkIfValid();
        this.sharedRealm.setAutoRefresh(autoRefresh);
    }

    public boolean isAutoRefresh() {
        return this.sharedRealm.isAutoRefresh();
    }

    public void refresh() {
        this.checkIfValid();
        this.checkAllowQueriesOnUiThread();
        if (this.isInTransaction()) {
            throw new IllegalStateException("Cannot refresh a Realm instance inside a transaction.");
        }
        this.sharedRealm.refresh();
    }

    public boolean isInTransaction() {
        this.checkIfValid();
        return this.sharedRealm.isInTransaction();
    }

    protected <T extends BaseRealm> void addListener(RealmChangeListener<T> listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        this.checkIfValid();
        this.sharedRealm.capabilities.checkCanDeliverNotification(LISTENER_NOT_ALLOWED_MESSAGE);
        if (this.frozen) {
            throw new IllegalStateException("It is not possible to add a change listener to a frozen Realm since it never changes.");
        }
        this.sharedRealm.realmNotifier.addChangeListener(this, listener2);
    }

    protected <T extends BaseRealm> void removeListener(RealmChangeListener<T> listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException("Listener should not be null");
        }
        if (this.isClosed()) {
            RealmLog.warn("Calling removeChangeListener on a closed Realm %s, make sure to close all listeners before closing the Realm.", this.configuration.getPath());
        }
        this.sharedRealm.realmNotifier.removeChangeListener(this, listener2);
    }

    public abstract Flowable asFlowable();

    protected void removeAllListeners() {
        if (this.isClosed()) {
            RealmLog.warn("Calling removeChangeListener on a closed Realm %s, make sure to close all listeners before closing the Realm.", this.configuration.getPath());
        }
        this.sharedRealm.realmNotifier.removeChangeListeners(this);
    }

    public void writeCopyTo(File destination) {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.sharedRealm.writeCopy(destination, null);
    }

    public void writeEncryptedCopyTo(File destination, byte[] key) {
        if (destination == null) {
            throw new IllegalArgumentException("The destination argument cannot be null");
        }
        this.checkIfValid();
        this.sharedRealm.writeCopy(destination, key);
    }

    @Deprecated
    public boolean waitForChange() {
        this.checkIfValid();
        if (this.isInTransaction()) {
            throw new IllegalStateException("Cannot wait for changes inside of a transaction.");
        }
        if (Looper.myLooper() != null) {
            throw new IllegalStateException("Cannot wait for changes inside a Looper thread. Use RealmChangeListeners instead.");
        }
        boolean hasChanged = this.sharedRealm.waitForChange();
        if (hasChanged) {
            this.sharedRealm.refresh();
        }
        return hasChanged;
    }

    @Deprecated
    public void stopWaitForChange() {
        if (this.realmCache == null) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        this.realmCache.invokeWithLock(new RealmCache.Callback0(){

            @Override
            public void onCall() {
                if (BaseRealm.this.sharedRealm == null || BaseRealm.this.sharedRealm.isClosed()) {
                    throw new IllegalStateException(BaseRealm.CLOSED_REALM_MESSAGE);
                }
                BaseRealm.this.sharedRealm.stopWaitForChange();
            }
        });
    }

    public void beginTransaction() {
        this.checkIfValid();
        this.sharedRealm.beginTransaction();
    }

    public void commitTransaction() {
        this.checkIfValid();
        this.sharedRealm.commitTransaction();
    }

    public void cancelTransaction() {
        this.checkIfValid();
        this.sharedRealm.cancelTransaction();
    }

    public abstract BaseRealm freeze();

    public boolean isFrozen() {
        if (this.sharedRealm == null || this.sharedRealm.isClosed()) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        return this.frozen;
    }

    public long getNumberOfActiveVersions() {
        this.checkIfValid();
        return this.getSharedRealm().getNumberOfVersions();
    }

    protected void checkIfValid() {
        if (this.sharedRealm == null || this.sharedRealm.isClosed()) {
            throw new IllegalStateException(CLOSED_REALM_MESSAGE);
        }
        if (!this.frozen && this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
    }

    protected void checkAllowQueriesOnUiThread() {
        if (this.getSharedRealm().capabilities.isMainThread() && !this.getConfiguration().isAllowQueriesOnUiThread()) {
            throw new RealmException("Queries on the UI thread have been disabled. They can be enabled by setting 'RealmConfiguration.Builder.allowQueriesOnUiThread(true)'.");
        }
    }

    protected void checkAllowWritesOnUiThread() {
        if (this.getSharedRealm().capabilities.isMainThread() && !this.getConfiguration().isAllowWritesOnUiThread()) {
            throw new RealmException("Running transactions on the UI thread has been disabled. It can be enabled by setting 'RealmConfiguration.Builder.allowWritesOnUiThread(true)'.");
        }
    }

    protected void checkIfInTransaction() {
        if (!this.sharedRealm.isInTransaction()) {
            throw new IllegalStateException(NOT_IN_TRANSACTION_MESSAGE);
        }
    }

    protected void checkIfValidAndInTransaction() {
        if (!this.isInTransaction()) {
            throw new IllegalStateException(NOT_IN_TRANSACTION_MESSAGE);
        }
    }

    Row getEmbeddedObjectRow(String className, RealmObjectProxy parentProxy, String parentProperty, RealmSchema schema, RealmObjectSchema parentObjectSchema) {
        long parentPropertyColKey = parentObjectSchema.getColumnKey(parentProperty);
        RealmFieldType parentPropertyType = parentObjectSchema.getFieldType(parentProperty);
        Row row = parentProxy.realmGet$proxyState().getRow$realm();
        RealmFieldType fieldType = parentObjectSchema.getFieldType(parentProperty);
        boolean propertyAcceptable = parentObjectSchema.isPropertyAcceptableForEmbeddedObject(fieldType);
        if (!propertyAcceptable) {
            throw new IllegalArgumentException(String.format("Field '%s' does not contain a valid link", parentProperty));
        }
        String linkedType = parentObjectSchema.getPropertyClassName(parentProperty);
        if (!linkedType.equals(className)) {
            throw new IllegalArgumentException(String.format("Parent type %s expects that property '%s' be of type %s but was %s.", parentObjectSchema.getClassName(), parentProperty, linkedType, className));
        }
        long objKey = row.createEmbeddedObject(parentPropertyColKey, parentPropertyType);
        CheckedRow embeddedObject = schema.getTable(className).getCheckedRow(objKey);
        return embeddedObject;
    }

    void checkNotInSync() {
        if (this.configuration.isSyncConfiguration()) {
            throw new UnsupportedOperationException("You cannot perform destructive changes to a schema of a synced Realm");
        }
    }

    public String getPath() {
        return this.configuration.getPath();
    }

    public RealmConfiguration getConfiguration() {
        return this.configuration;
    }

    public long getVersion() {
        return OsObjectStore.getSchemaVersion(this.sharedRealm);
    }

    @Override
    public void close() {
        if (!this.frozen && this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_CLOSE_MESSAGE);
        }
        if (this.realmCache != null) {
            this.realmCache.release(this);
        } else {
            this.doClose();
        }
    }

    void doClose() {
        this.realmCache = null;
        if (this.sharedRealm != null && this.shouldCloseSharedRealm) {
            this.sharedRealm.close();
            this.sharedRealm = null;
        }
    }

    public boolean isClosed() {
        if (!this.frozen && this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException(INCORRECT_THREAD_MESSAGE);
        }
        return this.sharedRealm == null || this.sharedRealm.isClosed();
    }

    public abstract boolean isEmpty();

    public abstract RealmSchema getSchema();

    <E extends RealmModel> E get(@Nullable Class<E> clazz, @Nullable String dynamicClassName, UncheckedRow row) {
        boolean isDynamicRealmObject = dynamicClassName != null;
        DynamicRealmObject result = isDynamicRealmObject ? new DynamicRealmObject(this, CheckedRow.getFromRow(row)) : this.configuration.getSchemaMediator().newInstance(clazz, this, row, this.getSchema().getColumnInfo(clazz), false, Collections.emptyList());
        return (E)result;
    }

    <E extends RealmModel> E get(Class<E> clazz, long rowKey, boolean acceptDefaultValue, List<String> excludeFields) {
        Table table = this.getSchema().getTable(clazz);
        UncheckedRow row = table.getUncheckedRow(rowKey);
        return this.configuration.getSchemaMediator().newInstance(clazz, this, row, this.getSchema().getColumnInfo(clazz), acceptDefaultValue, excludeFields);
    }

    <E extends RealmModel> E get(@Nullable Class<E> clazz, @Nullable String dynamicClassName, long rowIndex) {
        DynamicRealmObject dynamicObj;
        Table table;
        boolean isDynamicRealmObject = dynamicClassName != null;
        Table table2 = table = isDynamicRealmObject ? this.getSchema().getTable(dynamicClassName) : this.getSchema().getTable(clazz);
        DynamicRealmObject result = isDynamicRealmObject ? (dynamicObj = new DynamicRealmObject(this, rowIndex != -1L ? table.getCheckedRow(rowIndex) : InvalidRow.INSTANCE)) : this.configuration.getSchemaMediator().newInstance(clazz, this, rowIndex != -1L ? table.getUncheckedRow(rowIndex) : InvalidRow.INSTANCE, this.getSchema().getColumnInfo(clazz), false, Collections.emptyList());
        return (E)result;
    }

    public void deleteAll() {
        this.checkIfValid();
        for (RealmObjectSchema objectSchema : this.getSchema().getAll()) {
            this.getSchema().getTable(objectSchema.getClassName()).clear();
        }
    }

    static boolean deleteRealm(final RealmConfiguration configuration) {
        final AtomicBoolean realmDeleted = new AtomicBoolean(true);
        boolean callbackExecuted = OsObjectStore.callWithLock(configuration, new Runnable(){

            @Override
            public void run() {
                String canonicalPath = configuration.getPath();
                File realmFolder = configuration.getRealmDirectory();
                String realmFileName = configuration.getRealmFileName();
                realmDeleted.set(Util.deleteRealm(canonicalPath, realmFolder, realmFileName));
            }
        });
        if (!callbackExecuted) {
            throw new IllegalStateException("It's not allowed to delete the file associated with an open Realm. Remember to close() all the instances of the Realm before deleting its file: " + configuration.getPath());
        }
        return realmDeleted.get();
    }

    static boolean compactRealm(RealmConfiguration configuration) {
        OsSharedRealm sharedRealm = OsSharedRealm.getInstance(configuration, OsSharedRealm.VersionID.LIVE);
        Boolean result = sharedRealm.compact();
        sharedRealm.close();
        return result;
    }

    protected static void migrateRealm(final RealmConfiguration configuration, final @Nullable RealmMigration migration) throws FileNotFoundException {
        if (configuration == null) {
            throw new IllegalArgumentException("RealmConfiguration must be provided");
        }
        if (configuration.isSyncConfiguration()) {
            throw new IllegalArgumentException("Manual migrations are not supported for synced Realms");
        }
        if (migration == null && configuration.getMigration() == null) {
            throw new RealmMigrationNeededException(configuration.getPath(), "RealmMigration must be provided.");
        }
        final AtomicBoolean fileNotFound = new AtomicBoolean(false);
        RealmCache.invokeWithGlobalRefCount(configuration, new RealmCache.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(int count) {
                RealmMigration migrationToBeApplied;
                if (count != 0) {
                    throw new IllegalStateException("Cannot migrate a Realm file that is already open: " + configuration.getPath());
                }
                File realmFile = new File(configuration.getPath());
                if (!realmFile.exists()) {
                    fileNotFound.set(true);
                    return;
                }
                RealmProxyMediator mediator = configuration.getSchemaMediator();
                OsSchemaInfo schemaInfo = new OsSchemaInfo(mediator.getExpectedObjectSchemaInfoMap().values());
                OsSharedRealm.MigrationCallback migrationCallback = null;
                RealmMigration realmMigration = migrationToBeApplied = migration != null ? migration : configuration.getMigration();
                if (migrationToBeApplied != null) {
                    migrationCallback = BaseRealm.createMigrationCallback(migrationToBeApplied);
                }
                OsRealmConfig.Builder configBuilder = new OsRealmConfig.Builder(configuration).autoUpdateNotification(false).schemaInfo(schemaInfo).migrationCallback(migrationCallback);
                try (OsSharedRealm sharedRealm = null;){
                    sharedRealm = OsSharedRealm.getInstance(configBuilder, OsSharedRealm.VersionID.LIVE);
                }
            }
        });
        if (fileNotFound.get()) {
            throw new FileNotFoundException("Cannot migrate a Realm file which doesn't exist: " + configuration.getPath());
        }
    }

    private static OsSharedRealm.MigrationCallback createMigrationCallback(final RealmMigration migration) {
        return new OsSharedRealm.MigrationCallback(){

            @Override
            public void onMigrationNeeded(OsSharedRealm sharedRealm, long oldVersion, long newVersion) {
                migration.migrate(DynamicRealm.createInstance(sharedRealm), oldVersion, newVersion);
            }
        };
    }

    protected void finalize() throws Throwable {
        if (this.shouldCloseSharedRealm && this.sharedRealm != null && !this.sharedRealm.isClosed()) {
            RealmLog.warn("Remember to call close() on all Realm instances. Realm %s is being finalized without being closed, this can lead to running out of native memory.", this.configuration.getPath());
            if (this.realmCache != null) {
                this.realmCache.leak();
            }
        }
        super.finalize();
    }

    OsSharedRealm getSharedRealm() {
        return this.sharedRealm;
    }

    static {
        asyncTaskExecutor = RealmThreadPoolExecutor.newDefaultExecutor();
        WRITE_EXECUTOR = RealmThreadPoolExecutor.newSingleThreadExecutor();
        objectContext = new ThreadLocalRealmObjectContext();
    }

    public static abstract class InstanceCallback<T extends BaseRealm> {
        public abstract void onSuccess(T var1);

        public void onError(Throwable exception) {
            throw new RealmException("Exception happens when initializing Realm in the background thread.", exception);
        }
    }

    static final class ThreadLocalRealmObjectContext
    extends ThreadLocal<RealmObjectContext> {
        ThreadLocalRealmObjectContext() {
        }

        @Override
        protected RealmObjectContext initialValue() {
            return new RealmObjectContext();
        }
    }

    public static final class RealmObjectContext {
        private BaseRealm realm;
        private Row row;
        private ColumnInfo columnInfo;
        private boolean acceptDefaultValue;
        private List<String> excludeFields;

        public void set(BaseRealm realm, Row row, ColumnInfo columnInfo, boolean acceptDefaultValue, List<String> excludeFields) {
            this.realm = realm;
            this.row = row;
            this.columnInfo = columnInfo;
            this.acceptDefaultValue = acceptDefaultValue;
            this.excludeFields = excludeFields;
        }

        BaseRealm getRealm() {
            return this.realm;
        }

        public Row getRow() {
            return this.row;
        }

        public ColumnInfo getColumnInfo() {
            return this.columnInfo;
        }

        public boolean getAcceptDefaultValue() {
            return this.acceptDefaultValue;
        }

        public List<String> getExcludeFields() {
            return this.excludeFields;
        }

        public void clear() {
            this.realm = null;
            this.row = null;
            this.columnInfo = null;
            this.acceptDefaultValue = false;
            this.excludeFields = null;
        }
    }
}

