/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.ManagedMapManager;
import io.realm.MapChangeSet;
import io.realm.MapValueOperator;
import io.realm.RealmDictionary;
import io.realm.StringMapChangeSet;
import io.realm.TypeSelectorForMap;
import io.realm.internal.OsMap;
import io.realm.internal.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

class DictionaryManager<V>
extends ManagedMapManager<String, V> {
    DictionaryManager(BaseRealm baseRealm, MapValueOperator<String, V> mapValueOperator, TypeSelectorForMap<String, V> typeSelectorForMap) {
        super(baseRealm, mapValueOperator, typeSelectorForMap);
    }

    @Override
    boolean containsKeyInternal(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed when calling 'containsKey'.");
        }
        if (!this.isNotNullItemTypeValid(key, String.class)) {
            throw new ClassCastException("Only String keys can be used with 'containsKey'.");
        }
        return this.mapValueOperator.containsKey(key);
    }

    @Override
    void validateMap(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key != null) continue;
            throw new NullPointerException("Null keys are not allowed.");
        }
    }

    RealmDictionary<V> freezeInternal(Pair<BaseRealm, OsMap> frozenBaseRealmMap) {
        BaseRealm frozenBaseRealm = (BaseRealm)frozenBaseRealmMap.first;
        return this.typeSelectorForMap.freeze(frozenBaseRealm);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed when calling 'get'.");
        }
        if (!this.isNotNullItemTypeValid(key, String.class)) {
            throw new ClassCastException("Only String keys can be used with 'containsKey'.");
        }
        return this.mapValueOperator.get((String)key);
    }

    @Override
    public V put(String key, @Nullable V value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed.");
        }
        try {
            return this.mapValueOperator.put(key, value);
        }
        catch (IllegalStateException e) {
            if (Objects.requireNonNull(e.getMessage()).contains("Data type mismatch")) {
                throw new NullPointerException("Cannot insert null values in a dictionary marked with '@Required'.");
            }
            throw e;
        }
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.mapValueOperator.entrySet();
    }

    @Override
    MapChangeSet<String> changeSetFactory(long nativeChangeSetPtr) {
        return new StringMapChangeSet(nativeChangeSetPtr);
    }
}

