/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.CollectionUtils;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmQuery;
import io.realm.SetValueOperator;
import io.realm.internal.OsSet;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.core.NativeRealmAnyCollection;
import java.util.ArrayList;
import java.util.Collection;

class RealmModelSetOperator<T extends RealmModel>
extends SetValueOperator<T> {
    RealmModelSetOperator(BaseRealm baseRealm, OsSet osSet, Class<T> valueClass) {
        super(baseRealm, osSet, valueClass);
    }

    @Override
    boolean add(T value) {
        RealmObjectProxy proxy = (RealmObjectProxy)this.getManagedObject(value);
        Row row$realm = proxy.realmGet$proxyState().getRow$realm();
        return this.osSet.addRow(row$realm.getObjectKey());
    }

    private T getManagedObject(T value) {
        if (value == null) {
            throw new NullPointerException("This set does not permit null values.");
        }
        boolean copyObject = CollectionUtils.checkCanObjectBeCopied(this.baseRealm, value, this.valueClass.getName(), "set");
        return copyObject ? CollectionUtils.copyToRealm(this.baseRealm, value) : value;
    }

    private void checkValidObject(RealmModel value) {
        if (value == null) {
            throw new NullPointerException("This set does not permit null values.");
        }
        if (!RealmObject.isValid(value) || !RealmObject.isManaged(value)) {
            throw new IllegalArgumentException("'value' is not a valid managed object.");
        }
        if (((RealmObjectProxy)value).realmGet$proxyState().getRealm$realm() != this.baseRealm) {
            throw new IllegalArgumentException("'value' belongs to a different Realm.");
        }
    }

    @Override
    boolean containsInternal(Object value) {
        this.checkValidObject((RealmModel)value);
        Row row$realm = ((RealmObjectProxy)value).realmGet$proxyState().getRow$realm();
        return this.osSet.containsRow(row$realm.getObjectKey());
    }

    @Override
    boolean removeInternal(Object value) {
        this.checkValidObject((RealmModel)value);
        Row row$realm = ((RealmObjectProxy)value).realmGet$proxyState().getRow$realm();
        return this.osSet.removeRow(row$realm.getObjectKey());
    }

    @Override
    boolean containsAllInternal(Collection<?> collection) {
        Collection<?> realmModelCollection = collection;
        this.checkValidCollection(realmModelCollection);
        NativeRealmAnyCollection realmAnyCollection = NativeRealmAnyCollection.newRealmModelCollection(realmModelCollection);
        return this.osSet.collectionFunnel(realmAnyCollection, OsSet.ExternalCollectionOperation.CONTAINS_ALL);
    }

    @Override
    boolean addAllInternal(Collection<? extends T> collection) {
        ArrayList<RealmModel> managedRealmObjectCollection = new ArrayList<RealmModel>(collection.size());
        for (RealmModel item : collection) {
            managedRealmObjectCollection.add(this.getManagedObject(item));
        }
        NativeRealmAnyCollection realmAnyCollection = NativeRealmAnyCollection.newRealmModelCollection(managedRealmObjectCollection);
        return this.osSet.collectionFunnel(realmAnyCollection, OsSet.ExternalCollectionOperation.ADD_ALL);
    }

    @Override
    boolean removeAllInternal(Collection<?> c) {
        Collection<?> realmModelCollection = c;
        this.checkValidCollection(realmModelCollection);
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newRealmModelCollection(realmModelCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.REMOVE_ALL);
    }

    @Override
    boolean retainAllInternal(Collection<?> c) {
        Collection<?> realmModelCollection = c;
        this.checkValidCollection(realmModelCollection);
        NativeRealmAnyCollection collection = NativeRealmAnyCollection.newRealmModelCollection(realmModelCollection);
        return this.osSet.collectionFunnel(collection, OsSet.ExternalCollectionOperation.RETAIN_ALL);
    }

    private void checkValidCollection(Collection<? extends T> collection) {
        for (RealmModel object : collection) {
            this.checkValidObject(object);
        }
    }

    @Override
    RealmQuery<T> where() {
        return new RealmQuery(this.baseRealm, this.osSet, this.valueClass);
    }
}

