/*
 * Decompiled with CFR 0.152.
 */
package io.realm.gradle;

import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import io.realm.gradle.RealmKt;
import io.realm.gradle.RealmPluginExtension;
import io.realm.gradle.SimpleAGPVersion;
import io.realm.transformer.RealmTransformerKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.plugins.PluginCollection;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lio/realm/gradle/Realm;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "realm-gradle-plugin"})
public class Realm
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PluginCollection pluginCollection = project.getPlugins().withType(AppPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)pluginCollection, (String)"project.plugins.withType(AppPlugin::class.java)");
        PluginCollection isAndroidApp = pluginCollection;
        PluginCollection pluginCollection2 = project.getPlugins().withType(LibraryPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)pluginCollection2, (String)"project.plugins.withType\u2026ibraryPlugin::class.java)");
        PluginCollection isAndroidLib = pluginCollection2;
        if (isAndroidApp.isEmpty() && isAndroidLib.isEmpty()) {
            throw new GradleException("'com.android.application' or 'com.android.library' plugin required.");
        }
        Realm.Companion.checkCompatibleAGPVersion();
        boolean isKotlinProject = project.getPlugins().findPlugin("kotlin-android") != null || project.getPlugins().findPlugin("kotlin-multiplatform") != null;
        boolean hasAnnotationProcessorConfiguration = project.getConfigurations().findByName("annotationProcessor") != null;
        String dependencyConfigurationName = Realm.Companion.getDependencyConfigurationName(project);
        RealmPluginExtension extension = (RealmPluginExtension)project.getExtensions().create("realm", RealmPluginExtension.class, new Object[0]);
        extension.setKotlinExtensionsEnabled(isKotlinProject);
        RealmTransformerKt.registerRealmTransformerTask((Project)project);
        project.getDependencies().add(dependencyConfigurationName, (Object)"io.realm:realm-annotations:10.17.0");
        if (isKotlinProject) {
            project.getDependencies().add("kapt", (Object)"io.realm:realm-annotations-processor:10.17.0");
            project.getDependencies().add("kaptAndroidTest", (Object)"io.realm:realm-annotations-processor:10.17.0");
        } else {
            if (_Assertions.ENABLED && !hasAnnotationProcessorConfiguration) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            project.getDependencies().add("annotationProcessor", (Object)"io.realm:realm-annotations-processor:10.17.0");
            project.getDependencies().add("androidTestAnnotationProcessor", (Object)"io.realm:realm-annotations-processor:10.17.0");
        }
        project.afterEvaluate(arg_0 -> Realm.apply$lambda-1(dependencyConfigurationName, project, extension, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final void apply$lambda-1(String $dependencyConfigurationName, Project $project, RealmPluginExtension $extension, Project it) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$dependencyConfigurationName, (String)"$dependencyConfigurationName");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Object object = new String[]{$dependencyConfigurationName, "androidTestImplementation"};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String dependencyConfigurationName = (String)element$iv;
            boolean bl = false;
            Realm.Companion.setDependencies($project, dependencyConfigurationName, $extension.isSyncEnabled(), $extension.isKotlinExtensionsEnabled());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lio/realm/gradle/Realm$Companion;", "", "()V", "checkCompatibleAGPVersion", "", "getDependencyConfigurationName", "", "project", "Lorg/gradle/api/Project;", "setDependencies", "dependencyConfigurationName", "syncEnabled", "", "kotlinExtensionsEnabled", "realm-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkCompatibleAGPVersion() {
            SimpleAGPVersion version = SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION();
            if (version.compareTo(new SimpleAGPVersion(7, 4)) < 0) {
                throw new GradleException("Android Gradle Plugin " + version + " is not supported. Upgrade to Realm Java `10.15.0` or later.");
            }
            RealmKt.getLogger().debug("Realm Plugin used with AGP version: " + version.getMajor() + '.' + version.getMinor() + '.');
        }

        private final String getDependencyConfigurationName(Project project) {
            String string;
            String newDependencyName = "api";
            String oldDependencyName = "compile";
            try {
                project.getConfigurations().getByName(newDependencyName);
                string = newDependencyName;
            }
            catch (UnknownConfigurationException ignored) {
                string = oldDependencyName;
            }
            return string;
        }

        private final void setDependencies(Project project, String dependencyConfigurationName, boolean syncEnabled, boolean kotlinExtensionsEnabled) {
            Iterator iterator = project.getConfigurations().getByName(dependencyConfigurationName).getDependencies().iterator();
            while (iterator.hasNext()) {
                Dependency item = (Dependency)iterator.next();
                if (!Intrinsics.areEqual((Object)item.getGroup(), (Object)"io.realm")) continue;
                String string = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.name");
                if (StringsKt.startsWith$default((String)string, (String)"realm-android-library", (boolean)false, (int)2, null)) {
                    iterator.remove();
                }
                String string2 = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.name");
                if (!StringsKt.startsWith$default((String)string2, (String)"realm-android-kotlin-extensions", (boolean)false, (int)2, null)) continue;
                iterator.remove();
            }
            String syncArtifactName = "realm-android-library" + (syncEnabled ? "-object-server" : "");
            project.getDependencies().add(dependencyConfigurationName, (Object)("io.realm:" + syncArtifactName + ":10.17.0"));
            if (kotlinExtensionsEnabled) {
                String kotlinExtArtifactName = "realm-android-kotlin-extensions" + (syncEnabled ? "-object-server" : "");
                project.getDependencies().add(dependencyConfigurationName, (Object)("io.realm:" + kotlinExtArtifactName + ":10.17.0"));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

